@extends('layouts.dashboard',['title'=> "Imprest"])

@section('content')
<style>
    .title {
        width: 123px;
        height: 44px;
        font-family: 'Poppins';
        font-style: normal;
        font-weight: 800;
        font-size: 29px;
        line-height: 44px;
        color: #464E5F;
    }

    .totalAmount {
        width: 152px;
        height: 26px;
        font-family: 'Poppins';
        font-style: normal;
        font-weight: 600;
        font-size: 17px;
        line-height: 26px;
        color: #B5B5C3;
    }

    .amount {
        width: 142px;
        height: 38px;
        font-family: 'Poppins';
        font-style: normal;
        font-weight: 800;
        font-size: 25px;
        line-height: 38px;
        color: #464E5F;

    }

    .bankTransfer {
        height: 23px;
        font-family: 'Poppins';
        font-style: normal;
        font-weight: 600;
        font-size: 15px;
        color: #212121;

    }

    .bankTitle {
        width: 133px;
        height: 21px;
        font-family: 'Poppins';
        font-style: normal;
        font-weight: 500;
        font-size: 14px;
        line-height: 21px;
        color: #464E5F;

    }

    .new-button,
    .new-button * {
        box-sizing: border-box;
    }

    .new-button {
        background: #464e5f;
        border-radius: 6px;
        padding: 14px 17px 14px 17px;
        display: flex;
        flex-direction: row;
        gap: 10px;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
        width: 123px;
        height: 48px;
        position: relative;
    }

    .create-invoice {
        color: #ffffff;
        text-align: left;
        font-family: "Poppins-SemiBold", sans-serif;
        font-size: 12px;
        font-weight: 600;
        position: relative;
    }
</style>
<div class="w-full mt-4 relative  shadow-md sm:rounded-lg overflow-auto ">

    <div class="w-full mt-4 relative  shadow-md sm:rounded-lg overflow-auto ">

        <div class="title mx-4 mt-2">
            INVOICE
        </div>
        @if(count($errors) > 0 )

        <ul class="" style="list-style: none;">
            @foreach($errors->all() as $error)
            <li>
                <div class="p-4 mb-4 text-sm text-red-800 rounded-lg bg-red-50 dark:bg-gray-800 dark:text-red-400" role="alert">
                    <span class="font-medium">{{$error}}</span>
                </div>
            </li>
            @endforeach
        </ul>

        @endif
        @if(\Session::has('message'))
        <ul class="" style="list-style: none;">
            <li>
                <div class="p-4 mb-4 text-sm text-green-800 rounded-lg bg-green-50 dark:bg-gray-800 dark:text-green-400" role="alert">
                    <span class="font-medium">{{\Session::get('message')}}</span>
                </div>
            </li>
        </ul>
        @endif
        <div class="overflow-x-auto mt-12">
            <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
                <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                    <tr>
                        <th scope="col" class="px-4 py-3">Description</th>
                        <th scope="col" class="px-4 py-3">Unit</th>
                        <th scope="col" class="px-4 py-3">₦ Price</th>
                        <th scope="col" class="px-4 py-3">₦ Amount</th>
                        <th scope="col" class="px-4 py-3">
                            <span class="sr-only">Actions</span>
                        </th>
                    </tr>
                </thead>
                <tbody id="displayItems">


                </tbody>
                <div class="border-b dark:border-gray-700">
                    <th scope="row" class="px-4 py-3 font-medium text-gray-900 whitespace-nowrap dark:text-white"><input type="text" id="description" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="Enter description" required /></th>
                    <td class="px-4 py-3"><input type="number" id="unit" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="Number of unit" required /></td>
                    <td class="px-4 py-3"><input type="number" id="price" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="Price for each unit" required /></td>
                    <td class="px-4 py-3"><input type="number" id="amount" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="Amount" required disabled /></td>
                    <td class="px-4 py-3 flex items-center justify-end">
                        <button onclick="addItem()" class="mx-1 h-10 w-10">
                            <img class="h-10 w-10 rounded-lg" src="/icons/ButtonSettings.png" alt="" srcset="">
                        </button>

                    </td>
                </div>
            </table>

        </div>
        <div class="flex justify-between mt-8 mx-4">
            <div class="totalAmount">TOTAL AMOUNT</div>
            <div class="amount">₦<span id="totalSum">00</span>.00</div>
        </div>

        <form id="invoiceForm" action="/invoice" method="post" class="mt-8 mx-4">
            @csrf
            <div class="bankTransfer mb-6">BANK TRANSFER</div>
            <div class="flex justify-start items-center my-2">
                <label for="bankName" class="mr-2 bankTitle">Choose Bank</label>
                <select style="width: 220px;" class="block ml-2 p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" id="bankName" name="bankName" type="text" placeholder="Jane">
                    <option selected value="">Select Bank</option>
                </select>
            </div>
            <div class="flex justify-start items-center my-2">
                <label for="accountNumber" class="mr-2 bankTitle">Account Number:</label>
                <input style="width: 220px;" class="block ml-2 p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" id="accountNumber" name="accountNumber" type="text" placeholder="Enter payment account">
            </div>
            <div class="flex justify-start items-center my-2">
                <label for="accountName" class="mr-2 bankTitle">Account Name</label>
                <input style="width: 220px;" class="block ml-2 p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" id="accountName" name="accountName" type="text" placeholder="Account name">
                <div onclick="verifyAccount()" class="new-button mx-2">
                    <div class="create-invoice">Verify account</div>
                </div>

            </div>
            <input type="hidden" id="sumAmount" name="sumAmount" />
            <input type="hidden" id="items" name="items" />
            @if($invoiceId)
            <input type="hidden" id="invoiceId" name="invoiceId" value="{{$invoiceId}}" />
            @endif
        </form>

        <div class="flex justify-end my-4 mx-4">
            <div onclick="submitInvoice()" class="new-button">
                <div class="create-invoice">Create Invoice</div>
            </div>
        </div>

    </div>

</div>
<script>
    const displayItems = (itemsData) => {
        const displayArray = [];
        let totalSum = 0;
        for (let index = 0; index < itemsData.length; index++) {
            totalSum = totalSum + itemsData[index].amount;
            displayArray.push(`
                <tr class="border-b dark:border-gray-700">
                        <th scope="row" class="px-4 py-3 font-medium text-gray-900 whitespace-nowrap dark:text-white">${itemsData[index].description}</th>
                        <td class="px-4 py-3">${itemsData[index].unit}</td>
                        <td class="px-4 py-3">${itemsData[index].price}</td>
                        <td class="px-4 py-3">${itemsData[index].amount}</td>
                        <td class="px-4 py-3 flex items-center justify-end">
                            <button onclick=editItems(${index}) class="mx-1 h-10 w-10">
                                <img class="h-10 w-10 rounded-lg" src="/icons/ButtonTrash.png" alt="" srcset="">
                            </button>

                        </td>
                    </tr>
                `)
        }

        return {
            displayArray,
            totalSum
        };
    }
</script>
@if($invoice)
<script>
    const data = JSON.parse(' {!! $invoice->items !!} ');
    const itemsData = displayItems(data);
    let totalSum = itemsData.totalSum;
    document.getElementById("displayItems").innerHTML = itemsData.displayArray;
    document.getElementById("totalSum").innerHTML = totalSum.toLocaleString();
    localStorage.setItem("savedItems", JSON.stringify(data));
    document.getElementById("accountNumber").value = '{!! $invoice->accountNumber !!}';
    document.getElementById("accountName").value = '{!! $invoice->accountName !!}';
</script>
@endif

<script>
    async function fetchAsync(url, method, data) {

        const rawResponse = await fetch(url, {
            method,
            headers: {
                'Accept': 'application/json',
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(data),
        });
        const content = await rawResponse.json();

        return content;
    }
    const verifyAccount = async () => {
        const accountNumber = document.getElementById(`accountNumber`).value;
        const bankCode = document.getElementById(`bankName`).value;
        const theBankCode = bankCode.split("|");

        const csrf = "zXJHMrMrfJiMY4FfLSIYfy3lXpiy42w7MB4M6bRr";

        const stateData = await fetchAsync("/verify-account", "POST", {
            bankCode: theBankCode[0],
            accountNumber,
            _token: csrf
        });
        if (stateData.status === "success") {
            const accountDetails = stateData.data;
            document.getElementById(`accountName`).value =accountDetails.account_name;
        }
    }
    const editItems = (removeId) => {
        let itemsData = [];
        const loadedItems = localStorage.getItem("savedItems");
        let totalSum = 0;
        if (loadedItems) {
            const theData = JSON.parse(loadedItems);
            for (let index = 0; index < theData.length; index++) {
                if (index !== removeId) {
                    itemsData.push(theData[index]);
                }
            }
        }
        const displayData = displayItems(itemsData);
        totalSum = displayData.totalSum;
        document.getElementById("displayItems").innerHTML = displayData.displayArray;
        document.getElementById("totalSum").innerHTML = totalSum.toLocaleString();
        localStorage.setItem("savedItems", JSON.stringify(itemsData));
    }


    const addItem = () => {
        let itemsData = [];
        const loadedItems = localStorage.getItem("savedItems");
        if (loadedItems) {
            const theData = JSON.parse(loadedItems);
            for (let index = 0; index < theData.length; index++) {
                itemsData.push(theData[index]);
            }
        }
        const description = document.getElementById("description").value;
        const unit = document.getElementById("unit").value;
        const price = document.getElementById("price").value;

        if (description && unit && price) {
            itemsData.push({
                description,
                unit,
                price,
                amount: unit * price
            });
            const displayData = displayItems(itemsData);

            document.getElementById("displayItems").innerHTML = displayData.displayArray;
            document.getElementById("totalSum").innerHTML = displayData.totalSum.toLocaleString();
            localStorage.setItem("savedItems", JSON.stringify(itemsData));
            document.getElementById("description").value = "";
            document.getElementById("unit").value = "";
            document.getElementById("price").value = "";

        }


    }
    const bankList = [{
            "id": 132,
            "code": "560",
            "name": "Page MFBank"
        },
        {
            "id": 133,
            "code": "304",
            "name": "Stanbic Mobile Money"
        },
        {
            "id": 134,
            "code": "308",
            "name": "FortisMobile"
        },
        {
            "id": 135,
            "code": "328",
            "name": "TagPay"
        },
        {
            "id": 136,
            "code": "309",
            "name": "FBNMobile"
        },
        {
            "id": 137,
            "code": "011",
            "name": "First Bank of Nigeria"
        },
        {
            "id": 138,
            "code": "326",
            "name": "Sterling Mobile"
        },
        {
            "id": 139,
            "code": "990",
            "name": "Omoluabi Mortgage Bank"
        },
        {
            "id": 140,
            "code": "311",
            "name": "ReadyCash (Parkway)"
        },
        {
            "id": 141,
            "code": "057",
            "name": "Zenith Bank"
        },
        {
            "id": 142,
            "code": "068",
            "name": "Standard Chartered Bank"
        },
        {
            "id": 143,
            "code": "306",
            "name": "eTranzact"
        },
        {
            "id": 144,
            "code": "070",
            "name": "Fidelity Bank"
        },
        {
            "id": 145,
            "code": "023",
            "name": "CitiBank"
        },
        {
            "id": 146,
            "code": "215",
            "name": "Unity Bank"
        },
        {
            "id": 147,
            "code": "323",
            "name": "Access Money"
        },
        {
            "id": 148,
            "code": "302",
            "name": "Eartholeum"
        },
        {
            "id": 149,
            "code": "324",
            "name": "Hedonmark"
        },
        {
            "id": 150,
            "code": "325",
            "name": "MoneyBox"
        },
        {
            "id": 151,
            "code": "301",
            "name": "JAIZ Bank"
        },
        {
            "id": 152,
            "code": "050",
            "name": "Ecobank Plc"
        },
        {
            "id": 153,
            "code": "307",
            "name": "EcoMobile"
        },
        {
            "id": 154,
            "code": "318",
            "name": "Fidelity Mobile"
        },
        {
            "id": 155,
            "code": "319",
            "name": "TeasyMobile"
        },
        {
            "id": 156,
            "code": "999",
            "name": "NIP Virtual Bank"
        },
        {
            "id": 157,
            "code": "320",
            "name": "VTNetworks"
        },
        {
            "id": 158,
            "code": "221",
            "name": "Stanbic IBTC Bank"
        },
        {
            "id": 159,
            "code": "501",
            "name": "Fortis Microfinance Bank"
        },
        {
            "id": 160,
            "code": "329",
            "name": "PayAttitude Online"
        },
        {
            "id": 161,
            "code": "322",
            "name": "ZenithMobile"
        },
        {
            "id": 162,
            "code": "303",
            "name": "ChamsMobile"
        },
        {
            "id": 163,
            "code": "403",
            "name": "SafeTrust Mortgage Bank"
        },
        {
            "id": 164,
            "code": "551",
            "name": "Covenant Microfinance Bank"
        },
        {
            "id": 165,
            "code": "415",
            "name": "Imperial Homes Mortgage Bank"
        },
        {
            "id": 166,
            "code": "552",
            "name": "NPF MicroFinance Bank"
        },
        {
            "id": 167,
            "code": "526",
            "name": "Parralex"
        },
        {
            "id": 168,
            "code": "035",
            "name": "Wema Bank"
        },
        {
            "id": 169,
            "code": "084",
            "name": "Enterprise Bank"
        },
        {
            "id": 170,
            "code": "063",
            "name": "Diamond Bank"
        },
        {
            "id": 171,
            "code": "305",
            "name": "Paycom"
        },
        {
            "id": 172,
            "code": "100",
            "name": "SunTrust Bank"
        },
        {
            "id": 173,
            "code": "317",
            "name": "Cellulant"
        },
        {
            "id": 174,
            "code": "401",
            "name": "ASO Savings and & Loans"
        },
        {
            "id": 175,
            "code": "030",
            "name": "Heritage"
        },
        {
            "id": 176,
            "code": "402",
            "name": "Jubilee Life Mortgage Bank"
        },
        {
            "id": 177,
            "code": "058",
            "name": "GTBank Plc"
        },
        {
            "id": 178,
            "code": "032",
            "name": "Union Bank"
        },
        {
            "id": 179,
            "code": "232",
            "name": "Sterling Bank"
        },
        {
            "id": 180,
            "code": "076",
            "name": "Polaris Bank"
        },
        {
            "id": 181,
            "code": "082",
            "name": "Keystone Bank"
        },
        {
            "id": 182,
            "code": "327",
            "name": "Pagatech"
        },
        {
            "id": 183,
            "code": "559",
            "name": "Coronation Merchant Bank"
        },
        {
            "id": 184,
            "code": "601",
            "name": "FSDH"
        },
        {
            "id": 185,
            "code": "313",
            "name": "Mkudi"
        },
        {
            "id": 186,
            "code": "214",
            "name": "First City Monument Bank"
        },
        {
            "id": 187,
            "code": "314",
            "name": "FET"
        },
        {
            "id": 188,
            "code": "523",
            "name": "Trustbond"
        },
        {
            "id": 189,
            "code": "315",
            "name": "GTMobile"
        },
        {
            "id": 190,
            "code": "033",
            "name": "United Bank for Africa"
        },
        {
            "id": 191,
            "code": "044",
            "name": "Access Bank"
        },
        {
            "id": 567,
            "code": "90115",
            "name": "TCF MFB"
        },
        {
            "id": 1413,
            "code": "090175",
            "name": "Test bank"
        },
        {
            "id": 1731,
            "code": "103",
            "name": "Globus Bank"
        },
        {
            "id": 1800,
            "code": "000019",
            "name": "Enterprise Bank"
        },
        {
            "id": 1801,
            "code": "000025",
            "name": "Titan Trust Bank"
        },
        {
            "id": 1802,
            "code": "000026",
            "name": "Taj Bank Limited"
        },
        {
            "id": 1803,
            "code": "000028",
            "name": "Central Bank Of Nigeria"
        },
        {
            "id": 1804,
            "code": "000029",
            "name": "Lotus Bank"
        },
        {
            "id": 1805,
            "code": "000030",
            "name": "Parallex Bank"
        },
        {
            "id": 1806,
            "code": "000031",
            "name": "PremiumTrust Bank"
        },
        {
            "id": 1807,
            "code": "000033",
            "name": "ENaira"
        },
        {
            "id": 1808,
            "code": "000034",
            "name": "SIGNATURE BANK"
        },
        {
            "id": 1809,
            "code": "000036",
            "name": "Optimus Bank"
        },
        {
            "id": 1810,
            "code": "050001",
            "name": "County Finance Ltd"
        },
        {
            "id": 1811,
            "code": "050002",
            "name": "Fewchore Finance Company Limited"
        },
        {
            "id": 1812,
            "code": "050003",
            "name": "Sagegrey Finance Limited"
        },
        {
            "id": 1813,
            "code": "050004",
            "name": "Newedge Finance Ltd"
        },
        {
            "id": 1814,
            "code": "050005",
            "name": "Aaa Finance"
        },
        {
            "id": 1815,
            "code": "050006",
            "name": "Branch International Financial Services"
        },
        {
            "id": 1816,
            "code": "050007",
            "name": "Tekla Finance Ltd"
        },
        {
            "id": 1817,
            "code": "050008",
            "name": "SIMPLE FINANCE LIMITED"
        },
        {
            "id": 1818,
            "code": "050009",
            "name": "FAST CREDIT"
        },
        {
            "id": 1819,
            "code": "050010",
            "name": "FUNDQUEST FINANCIAL SERVICES LTD"
        },
        {
            "id": 1820,
            "code": "050012",
            "name": "Enco Finance"
        },
        {
            "id": 1821,
            "code": "050013",
            "name": "Dignity Finance"
        },
        {
            "id": 1822,
            "code": "050014",
            "name": "TRINITY FINANCIAL SERVICES LIMITED"
        },
        {
            "id": 1823,
            "code": "060001",
            "name": "Coronation Merchant Bank"
        },
        {
            "id": 1824,
            "code": "060002",
            "name": "FBNQUEST Merchant Bank"
        },
        {
            "id": 1825,
            "code": "060003",
            "name": "Nova Merchant Bank"
        },
        {
            "id": 1826,
            "code": "060004",
            "name": "Greenwich Merchant Bank"
        },
        {
            "id": 1827,
            "code": "070001",
            "name": "NPF MicroFinance Bank"
        },
        {
            "id": 1828,
            "code": "070002",
            "name": "Fortis Microfinance Bank"
        },
        {
            "id": 1829,
            "code": "070006",
            "name": "Covenant Microfinance Bank"
        },
        {
            "id": 1830,
            "code": "070007",
            "name": "Omoluabi savings and loans"
        },
        {
            "id": 1831,
            "code": "070008",
            "name": "Page Financials"
        },
        {
            "id": 1832,
            "code": "070009",
            "name": "Gateway Mortgage Bank"
        },
        {
            "id": 1833,
            "code": "070010",
            "name": "Abbey Mortgage Bank"
        },
        {
            "id": 1834,
            "code": "070011",
            "name": "Refuge Mortgage Bank"
        },
        {
            "id": 1835,
            "code": "070012",
            "name": "Lagos Building Investment Company"
        },
        {
            "id": 1836,
            "code": "070013",
            "name": "Platinum Mortgage Bank"
        },
        {
            "id": 1837,
            "code": "070014",
            "name": "First Generation Mortgage Bank"
        },
        {
            "id": 1838,
            "code": "070015",
            "name": "Brent Mortgage Bank"
        },
        {
            "id": 1839,
            "code": "070016",
            "name": "Infinity Trust Mortgage Bank"
        },
        {
            "id": 1840,
            "code": "070017",
            "name": "Haggai Mortgage Bank Limited"
        },
        {
            "id": 1841,
            "code": "070019",
            "name": "Mayfresh Mortgage Bank"
        },
        {
            "id": 1842,
            "code": "070021",
            "name": "Coop Mortgage Bank"
        },
        {
            "id": 1843,
            "code": "070022",
            "name": "Stb Mortgage Bank"
        },
        {
            "id": 1844,
            "code": "070023",
            "name": "Delta Trust Mortgage Bank"
        },
        {
            "id": 1845,
            "code": "070024",
            "name": "Homebase Mortgage"
        },
        {
            "id": 1846,
            "code": "070025",
            "name": "Akwa Savings & Loans Limited"
        },
        {
            "id": 1847,
            "code": "070026",
            "name": "Fha Mortgage Bank Ltd"
        },
        {
            "id": 1848,
            "code": "080002",
            "name": "Tajwallet"
        },
        {
            "id": 1849,
            "code": "090001",
            "name": "ASOSavings & Loans"
        },
        {
            "id": 1850,
            "code": "090003",
            "name": "Jubilee-Life Mortgage  Bank"
        },
        {
            "id": 1851,
            "code": "090004",
            "name": "Parralex Microfinance bank"
        },
        {
            "id": 1852,
            "code": "090005",
            "name": "Trustbond Mortgage Bank"
        },
        {
            "id": 1853,
            "code": "090006",
            "name": "SafeTrust "
        },
        {
            "id": 1854,
            "code": "090097",
            "name": "Ekondo MFB"
        },
        {
            "id": 1855,
            "code": "090107",
            "name": "FBN Mortgages Limited"
        },
        {
            "id": 1856,
            "code": "090108",
            "name": "New Prudential Bank"
        },
        {
            "id": 1857,
            "code": "090110",
            "name": "VFD Micro Finance Bank"
        },
        {
            "id": 1858,
            "code": "090112",
            "name": "Seed Capital Microfinance Bank"
        },
        {
            "id": 1859,
            "code": "090113",
            "name": "Microvis Microfinance Bank"
        },
        {
            "id": 1860,
            "code": "090114",
            "name": "Empire trust MFB"
        },
        {
            "id": 1861,
            "code": "090115",
            "name": "TCF MFB"
        },
        {
            "id": 1862,
            "code": "090116",
            "name": "AMML MFB"
        },
        {
            "id": 1863,
            "code": "090117",
            "name": "Boctrust Microfinance Bank"
        },
        {
            "id": 1864,
            "code": "090118",
            "name": "IBILE Microfinance Bank"
        },
        {
            "id": 1865,
            "code": "090119",
            "name": "Ohafia Microfinance Bank"
        },
        {
            "id": 1866,
            "code": "090120",
            "name": "Wetland Microfinance Bank"
        },
        {
            "id": 1867,
            "code": "090121",
            "name": "Hasal Microfinance Bank"
        },
        {
            "id": 1868,
            "code": "090122",
            "name": "Gowans Microfinance Bank"
        },
        {
            "id": 1869,
            "code": "090123",
            "name": "Verite Microfinance Bank"
        },
        {
            "id": 1870,
            "code": "090124",
            "name": "Xslnce Microfinance Bank"
        },
        {
            "id": 1871,
            "code": "090125",
            "name": "Regent Microfinance Bank"
        },
        {
            "id": 1872,
            "code": "090126",
            "name": "Fidfund Microfinance Bank"
        },
        {
            "id": 1873,
            "code": "090127",
            "name": "BC Kash Microfinance Bank"
        },
        {
            "id": 1874,
            "code": "090128",
            "name": "Ndiorah Microfinance Bank"
        },
        {
            "id": 1875,
            "code": "090129",
            "name": "Money Trust Microfinance Bank"
        },
        {
            "id": 1876,
            "code": "090130",
            "name": "Consumer Microfinance Bank"
        },
        {
            "id": 1877,
            "code": "090131",
            "name": "Allworkers Microfinance Bank"
        },
        {
            "id": 1878,
            "code": "090132",
            "name": "Richway Microfinance Bank"
        },
        {
            "id": 1879,
            "code": "090133",
            "name": " AL-Barakah Microfinance Bank"
        },
        {
            "id": 1880,
            "code": "090134",
            "name": "Accion Microfinance Bank"
        },
        {
            "id": 1881,
            "code": "090135",
            "name": "Personal Trust Microfinance Bank"
        },
        {
            "id": 1882,
            "code": "090136",
            "name": "Baobab Microfinance Bank"
        },
        {
            "id": 1883,
            "code": "090137",
            "name": "PecanTrust Microfinance Bank"
        },
        {
            "id": 1884,
            "code": "090138",
            "name": "Royal Exchange Microfinance Bank"
        },
        {
            "id": 1885,
            "code": "090139",
            "name": "Visa Microfinance Bank"
        },
        {
            "id": 1886,
            "code": "090140",
            "name": "Sagamu Microfinance Bank"
        },
        {
            "id": 1887,
            "code": "090141",
            "name": "Chikum Microfinance Bank"
        },
        {
            "id": 1888,
            "code": "090142",
            "name": "Yes Microfinance Bank"
        },
        {
            "id": 1889,
            "code": "090143",
            "name": "Apeks Microfinance Bank"
        },
        {
            "id": 1890,
            "code": "090144",
            "name": "CIT Microfinance Bank"
        },
        {
            "id": 1891,
            "code": "090145",
            "name": "Fullrange Microfinance Bank"
        },
        {
            "id": 1892,
            "code": "090146",
            "name": "Trident Microfinance Bank"
        },
        {
            "id": 1893,
            "code": "090147",
            "name": "Hackman Microfinance Bank"
        },
        {
            "id": 1894,
            "code": "090148",
            "name": "Bowen Microfinance Bank"
        },
        {
            "id": 1895,
            "code": "090149",
            "name": "IRL Microfinance Bank"
        },
        {
            "id": 1896,
            "code": "090150",
            "name": "Virtue Microfinance Bank"
        },
        {
            "id": 1897,
            "code": "090151",
            "name": "Mutual Trust Microfinance Bank"
        },
        {
            "id": 1898,
            "code": "090152",
            "name": "Nagarta Microfinance Bank"
        },
        {
            "id": 1899,
            "code": "090153",
            "name": "FFS Microfinance Bank"
        },
        {
            "id": 1900,
            "code": "090154",
            "name": "CEMCS Microfinance Bank"
        },
        {
            "id": 1901,
            "code": "090155",
            "name": "La  Fayette Microfinance Bank"
        },
        {
            "id": 1902,
            "code": "090156",
            "name": "e-Barcs Microfinance Bank"
        },
        {
            "id": 1903,
            "code": "090157",
            "name": "Infinity Microfinance Bank"
        },
        {
            "id": 1904,
            "code": "090158",
            "name": "Futo Microfinance Bank"
        },
        {
            "id": 1905,
            "code": "090159",
            "name": "Credit Afrique Microfinance Bank"
        },
        {
            "id": 1906,
            "code": "090160",
            "name": "Addosser Microfinance Bank"
        },
        {
            "id": 1907,
            "code": "090161",
            "name": "Okpoga Microfinance Bank"
        },
        {
            "id": 1908,
            "code": "090162",
            "name": "Stanford Microfinance Bak"
        },
        {
            "id": 1909,
            "code": "090163",
            "name": "First Multiple Microfinance Bank"
        },
        {
            "id": 1910,
            "code": "090164",
            "name": "First Royal Microfinance Bank"
        },
        {
            "id": 1911,
            "code": "090165",
            "name": "Petra Microfinance Bank"
        },
        {
            "id": 1912,
            "code": "090166",
            "name": "Eso-E Microfinance Bank"
        },
        {
            "id": 1913,
            "code": "090167",
            "name": "Daylight Microfinance Bank"
        },
        {
            "id": 1914,
            "code": "090168",
            "name": "Gashua Microfinance Bank"
        },
        {
            "id": 1915,
            "code": "090169",
            "name": "Alpha Kapital Microfinance Bank"
        },
        {
            "id": 1916,
            "code": "090170",
            "name": "Rahama Microfinance Bank"
        },
        {
            "id": 1917,
            "code": "090171",
            "name": "Mainstreet Microfinance Bank"
        },
        {
            "id": 1918,
            "code": "090172",
            "name": "Astrapolaris Microfinance Bank"
        },
        {
            "id": 1919,
            "code": "090173",
            "name": "Reliance Microfinance Bank"
        },
        {
            "id": 1920,
            "code": "090174",
            "name": "Malachy Microfinance Bank"
        },
        {
            "id": 1921,
            "code": "090176",
            "name": "Bosak Microfinance Bank"
        },
        {
            "id": 1922,
            "code": "090177",
            "name": "Lapo Microfinance Bank"
        },
        {
            "id": 1923,
            "code": "090178",
            "name": "GreenBank Microfinance Bank"
        },
        {
            "id": 1924,
            "code": "090179",
            "name": "FAST Microfinance Bank"
        },
        {
            "id": 1925,
            "code": "090180",
            "name": "AMJU Unique Microfinance Bank"
        },
        {
            "id": 1926,
            "code": "090181",
            "name": "Balogun Fulani  Microfinance Bank"
        },
        {
            "id": 1927,
            "code": "090182",
            "name": "Standard Microfinance Bank"
        },
        {
            "id": 1928,
            "code": "090186",
            "name": "Girei Microfinance Bank"
        },
        {
            "id": 1929,
            "code": "090188",
            "name": "Baines Credit Microfinance Bank"
        },
        {
            "id": 1930,
            "code": "090189",
            "name": "Esan Microfinance Bank"
        },
        {
            "id": 1931,
            "code": "090190",
            "name": "Mutual Benefits Microfinance Bank"
        },
        {
            "id": 1932,
            "code": "090191",
            "name": "KCMB Microfinance Bank"
        },
        {
            "id": 1933,
            "code": "090192",
            "name": "Midland Microfinance Bank"
        },
        {
            "id": 1934,
            "code": "090193",
            "name": "Unical Microfinance Bank"
        },
        {
            "id": 1935,
            "code": "090194",
            "name": "NIRSAL Microfinance Bank"
        },
        {
            "id": 1936,
            "code": "090195",
            "name": "Grooming Microfinance Bank"
        },
        {
            "id": 1937,
            "code": "090196",
            "name": "Pennywise Microfinance Bank"
        },
        {
            "id": 1938,
            "code": "090197",
            "name": "ABU Microfinance Bank"
        },
        {
            "id": 1939,
            "code": "090198",
            "name": "RenMoney Microfinance Bank"
        },
        {
            "id": 1940,
            "code": "090201",
            "name": "Xpress Payments"
        },
        {
            "id": 1941,
            "code": "090202",
            "name": "Accelerex Network"
        },
        {
            "id": 1942,
            "code": "090205",
            "name": "New Dawn Microfinance Bank"
        },
        {
            "id": 1943,
            "code": "090211",
            "name": "Itex Integrated Services Limited"
        },
        {
            "id": 1944,
            "code": "090251",
            "name": "UNN MFB"
        },
        {
            "id": 1945,
            "code": "090252",
            "name": "Yobe Microfinance Bank"
        },
        {
            "id": 1946,
            "code": "090254",
            "name": "Coalcamp Microfinance Bank"
        },
        {
            "id": 1947,
            "code": "090258",
            "name": "Imo State Microfinance Bank"
        },
        {
            "id": 1948,
            "code": "090259",
            "name": "Alekun Microfinance Bank"
        },
        {
            "id": 1949,
            "code": "090260",
            "name": "Above Only Microfinance Bank"
        },
        {
            "id": 1950,
            "code": "090261",
            "name": "Quickfund Microfinance Bank"
        },
        {
            "id": 1951,
            "code": "090262",
            "name": "Stellas Microfinance Bank"
        },
        {
            "id": 1952,
            "code": "090263",
            "name": "Navy Microfinance Bank"
        },
        {
            "id": 1953,
            "code": "090264",
            "name": "Auchi Microfinance Bank"
        },
        {
            "id": 1954,
            "code": "090265",
            "name": "Lovonus Microfinance Bank"
        },
        {
            "id": 1955,
            "code": "090266",
            "name": "Uniben Microfinance Bank"
        },
        {
            "id": 1956,
            "code": "090267",
            "name": "Kuda"
        },
        {
            "id": 1957,
            "code": "090268",
            "name": "Adeyemi College Staff Microfinance Bank"
        },
        {
            "id": 1958,
            "code": "090269",
            "name": "Greenville Microfinance Bank"
        },
        {
            "id": 1959,
            "code": "090270",
            "name": "AB Microfinance Bank"
        },
        {
            "id": 1960,
            "code": "090271",
            "name": "Lavender Microfinance Bank"
        },
        {
            "id": 1961,
            "code": "090272",
            "name": "Olabisi Onabanjo University Microfinance Bank"
        },
        {
            "id": 1962,
            "code": "090273",
            "name": "Emeralds Microfinance Bank"
        },
        {
            "id": 1963,
            "code": "090274",
            "name": "Prestige Microfinance Bank"
        },
        {
            "id": 1964,
            "code": "090275",
            "name": "Meridian Microfinance Bank"
        },
        {
            "id": 1965,
            "code": "090276",
            "name": "Trustfund Microfinance Bank"
        },
        {
            "id": 1966,
            "code": "090277",
            "name": "Al-Hayat Microfinance Bank"
        },
        {
            "id": 1967,
            "code": "090278",
            "name": "Glory Microfinance Bank "
        },
        {
            "id": 1968,
            "code": "090279",
            "name": "Ikire Microfinance Bank"
        },
        {
            "id": 1969,
            "code": "090280",
            "name": "Megapraise Microfinance Bank"
        },
        {
            "id": 1970,
            "code": "090281",
            "name": "Mint-Finex MICROFINANCE BANK"
        },
        {
            "id": 1971,
            "code": "090282",
            "name": "Arise Microfinance Bank"
        },
        {
            "id": 1972,
            "code": "090283",
            "name": "Thrive Microfinance Bank"
        },
        {
            "id": 1973,
            "code": "090285",
            "name": "First Option Microfinance Bank"
        },
        {
            "id": 1974,
            "code": "090286",
            "name": "Safe Haven MFB"
        },
        {
            "id": 1975,
            "code": "090287",
            "name": "Assets Matrix Microfinance Bank"
        },
        {
            "id": 1976,
            "code": "090289",
            "name": "Pillar Microfinance Bank"
        },
        {
            "id": 1977,
            "code": "090290",
            "name": "Fct Microfinance Bank"
        },
        {
            "id": 1978,
            "code": "090291",
            "name": "Halacredit Microfinance Bank"
        },
        {
            "id": 1979,
            "code": "090292",
            "name": "Afekhafe Microfinance Bank"
        },
        {
            "id": 1980,
            "code": "090293",
            "name": "Brethren Microfinance Bank"
        },
        {
            "id": 1981,
            "code": "090294",
            "name": "Eagle Flight Microfinance Bank"
        },
        {
            "id": 1982,
            "code": "090295",
            "name": "Omiye Microfinance Bank"
        },
        {
            "id": 1983,
            "code": "090296",
            "name": "Polyuwanna Microfinance Bank"
        },
        {
            "id": 1984,
            "code": "090297",
            "name": "Alert Microfinance Bank"
        },
        {
            "id": 1985,
            "code": "090298",
            "name": "Federalpoly Nasarawamfb"
        },
        {
            "id": 1986,
            "code": "090299",
            "name": "Kontagora Microfinance Bank"
        },
        {
            "id": 1987,
            "code": "090302",
            "name": "Sunbeam Microfinance Bank"
        },
        {
            "id": 1988,
            "code": "090303",
            "name": "Purplemoney Microfinance Bank"
        },
        {
            "id": 1989,
            "code": "090304",
            "name": "Evangel Microfinance Bank"
        },
        {
            "id": 1990,
            "code": "090305",
            "name": "Sulsap Microfinance Bank"
        },
        {
            "id": 1991,
            "code": "090307",
            "name": "Aramoko Microfinance Bank"
        },
        {
            "id": 1992,
            "code": "090308",
            "name": "Brightway Microfinance Bank"
        },
        {
            "id": 1993,
            "code": "090310",
            "name": "Edfin Microfinance Bank"
        },
        {
            "id": 1994,
            "code": "090315",
            "name": "U And C Microfinance Bank"
        },
        {
            "id": 1995,
            "code": "090316",
            "name": "Bayero Microfinance Bank"
        },
        {
            "id": 1996,
            "code": "090317",
            "name": "PatrickGold Microfinance Bank"
        },
        {
            "id": 1997,
            "code": "090318",
            "name": "Federal University Dutse  Microfinance Bank"
        },
        {
            "id": 1998,
            "code": "090319",
            "name": "Bonghe Microfinance Bank"
        },
        {
            "id": 1999,
            "code": "090320",
            "name": "Kadpoly Microfinance Bank"
        },
        {
            "id": 2000,
            "code": "090321",
            "name": "Mayfair  Microfinance Bank"
        },
        {
            "id": 2001,
            "code": "090322",
            "name": "Rephidim Microfinance Bank"
        },
        {
            "id": 2002,
            "code": "090323",
            "name": "Mainland Microfinance Bank"
        },
        {
            "id": 2003,
            "code": "090324",
            "name": "Ikenne Microfinance Bank"
        },
        {
            "id": 2004,
            "code": "090325",
            "name": "Sparkle"
        },
        {
            "id": 2005,
            "code": "090326",
            "name": "Balogun Gambari Microfinance Bank"
        },
        {
            "id": 2006,
            "code": "090327",
            "name": "Trust Microfinance Bank"
        },
        {
            "id": 2007,
            "code": "090328",
            "name": "Eyowo MFB"
        },
        {
            "id": 2008,
            "code": "090329",
            "name": "Neptune Microfinance Bank"
        },
        {
            "id": 2009,
            "code": "090330",
            "name": "Fame Microfinance Bank"
        },
        {
            "id": 2010,
            "code": "090331",
            "name": "Unaab Microfinance Bank"
        },
        {
            "id": 2011,
            "code": "090332",
            "name": "Evergreen Microfinance Bank"
        },
        {
            "id": 2012,
            "code": "090333",
            "name": "Oche Microfinance Bank"
        },
        {
            "id": 2013,
            "code": "090335",
            "name": "Grant MF Bank"
        },
        {
            "id": 2014,
            "code": "090336",
            "name": "Bipc Microfinance Bank"
        },
        {
            "id": 2015,
            "code": "090337",
            "name": "Iyeru Okin Microfinance Bank Ltd"
        },
        {
            "id": 2016,
            "code": "090338",
            "name": "Uniuyo Microfinance Bank"
        },
        {
            "id": 2017,
            "code": "090340",
            "name": "Stockcorp  Microfinance Bank"
        },
        {
            "id": 2018,
            "code": "090341",
            "name": "Unilorin Microfinance Bank"
        },
        {
            "id": 2019,
            "code": "090343",
            "name": "Citizen Trust Microfinance Bank Ltd"
        },
        {
            "id": 2020,
            "code": "090345",
            "name": "Oau Microfinance Bank Ltd"
        },
        {
            "id": 2021,
            "code": "090349",
            "name": "Nasarawa Microfinance Bank"
        },
        {
            "id": 2022,
            "code": "090350",
            "name": "Illorin Microfinance Bank"
        },
        {
            "id": 2023,
            "code": "090352",
            "name": "Jessefield Microfinance Bank"
        },
        {
            "id": 2024,
            "code": "090353",
            "name": "Isuofia Microfinance Bank"
        },
        {
            "id": 2025,
            "code": "090360",
            "name": "Cashconnect   Microfinance Bank"
        },
        {
            "id": 2026,
            "code": "090362",
            "name": "Molusi Microfinance Bank"
        },
        {
            "id": 2027,
            "code": "090363",
            "name": "Headway Microfinance Bank"
        },
        {
            "id": 2028,
            "code": "090364",
            "name": "Nuture Microfinance Bank"
        },
        {
            "id": 2029,
            "code": "090365",
            "name": "Corestep Microfinance Bank"
        },
        {
            "id": 2030,
            "code": "090366",
            "name": "Firmus MFB"
        },
        {
            "id": 2031,
            "code": "090369",
            "name": "Seedvest Microfinance Bank"
        },
        {
            "id": 2032,
            "code": "090370",
            "name": "Ilasan Microfinance Bank"
        },
        {
            "id": 2033,
            "code": "090371",
            "name": "Agosasa Microfinance Bank"
        },
        {
            "id": 2034,
            "code": "090372",
            "name": "Legend Microfinance Bank"
        },
        {
            "id": 2035,
            "code": "090373",
            "name": "Tf Microfinance Bank"
        },
        {
            "id": 2036,
            "code": "090374",
            "name": "Coastline Microfinance Bank"
        },
        {
            "id": 2037,
            "code": "090376",
            "name": "Apple  Microfinance Bank"
        },
        {
            "id": 2038,
            "code": "090377",
            "name": "Isaleoyo Microfinance Bank"
        },
        {
            "id": 2039,
            "code": "090378",
            "name": "New Golden Pastures Microfinance Bank"
        },
        {
            "id": 2040,
            "code": "090379",
            "name": "Peniel Micorfinance Bank Ltd"
        },
        {
            "id": 2041,
            "code": "090380",
            "name": "Kredi Money Microfinance Bank"
        },
        {
            "id": 2042,
            "code": "090383",
            "name": "Manny Microfinance bank"
        },
        {
            "id": 2043,
            "code": "090385",
            "name": "Gti  Microfinance Bank"
        },
        {
            "id": 2044,
            "code": "090386",
            "name": "Interland Microfinance Bank"
        },
        {
            "id": 2045,
            "code": "090389",
            "name": "Ek-Reliable Microfinance Bank"
        },
        {
            "id": 2046,
            "code": "090390",
            "name": "Parkway Mf Bank"
        },
        {
            "id": 2047,
            "code": "090391",
            "name": "Davodani  Microfinance Bank"
        },
        {
            "id": 2048,
            "code": "090392",
            "name": "Mozfin Microfinance Bank"
        },
        {
            "id": 2049,
            "code": "090393",
            "name": "BRIDGEWAY MICROFINANCE BANK"
        },
        {
            "id": 2050,
            "code": "090394",
            "name": "Amac Microfinance Bank"
        },
        {
            "id": 2051,
            "code": "090395",
            "name": "Borgu Microfinance Bank"
        },
        {
            "id": 2052,
            "code": "090396",
            "name": "Oscotech Microfinance Bank"
        },
        {
            "id": 2053,
            "code": "090397",
            "name": "Chanelle Bank"
        },
        {
            "id": 2054,
            "code": "090398",
            "name": "Federal Polytechnic Nekede Microfinance Bank"
        },
        {
            "id": 2055,
            "code": "090399",
            "name": "Nwannegadi Microfinance Bank"
        },
        {
            "id": 2056,
            "code": "090400",
            "name": "Finca Microfinance Bank"
        },
        {
            "id": 2057,
            "code": "090401",
            "name": "Shepherd Trust Microfinance Bank"
        },
        {
            "id": 2058,
            "code": "090402",
            "name": "Peace Microfinance Bank"
        },
        {
            "id": 2059,
            "code": "090403",
            "name": "Uda Microfinance Bank"
        },
        {
            "id": 2060,
            "code": "090404",
            "name": "Olowolagba Microfinance Bank"
        },
        {
            "id": 2061,
            "code": "090405",
            "name": "Moniepoint Microfinance Bank"
        },
        {
            "id": 2062,
            "code": "090406",
            "name": "Business Support Microfinance Bank"
        },
        {
            "id": 2063,
            "code": "090408",
            "name": "Gmb Microfinance Bank"
        },
        {
            "id": 2064,
            "code": "090409",
            "name": "Fcmb Microfinance Bank"
        },
        {
            "id": 2065,
            "code": "090410",
            "name": "Maritime Microfinance Bank"
        },
        {
            "id": 2066,
            "code": "090411",
            "name": "Giginya Microfinance Bank"
        },
        {
            "id": 2067,
            "code": "090412",
            "name": "Preeminent Microfinance Bank"
        },
        {
            "id": 2068,
            "code": "090413",
            "name": "Benysta Microfinance Bank"
        },
        {
            "id": 2069,
            "code": "090414",
            "name": "Crutech  Microfinance Bank"
        },
        {
            "id": 2070,
            "code": "090415",
            "name": "Calabar Microfinance Bank"
        },
        {
            "id": 2071,
            "code": "090416",
            "name": "Chibueze Microfinance Bank"
        },
        {
            "id": 2072,
            "code": "090417",
            "name": "Imowo Microfinance Bank"
        },
        {
            "id": 2073,
            "code": "090418",
            "name": "Highland Microfinance Bank"
        },
        {
            "id": 2074,
            "code": "090419",
            "name": "Winview Bank"
        },
        {
            "id": 2075,
            "code": "090420",
            "name": "Letshego MFB"
        },
        {
            "id": 2076,
            "code": "090421",
            "name": "Izon Microfinance Bank"
        },
        {
            "id": 2077,
            "code": "090422",
            "name": "Landgold  Microfinance Bank"
        },
        {
            "id": 2078,
            "code": "090423",
            "name": "MAUTECH Microfinance Bank"
        },
        {
            "id": 2079,
            "code": "090424",
            "name": "Abucoop  Microfinance Bank"
        },
        {
            "id": 2080,
            "code": "090425",
            "name": "Banex Microfinance Bank"
        },
        {
            "id": 2081,
            "code": "090426",
            "name": "Tangerine Bank"
        },
        {
            "id": 2082,
            "code": "090427",
            "name": "Ebsu Microfinance Bank"
        },
        {
            "id": 2083,
            "code": "090428",
            "name": "Ishie  Microfinance Bank"
        },
        {
            "id": 2084,
            "code": "090429",
            "name": "Crossriver  Microfinance Bank"
        },
        {
            "id": 2085,
            "code": "090430",
            "name": "Ilora Microfinance Bank"
        },
        {
            "id": 2086,
            "code": "090431",
            "name": "Bluewhales  Microfinance Bank"
        },
        {
            "id": 2087,
            "code": "090432",
            "name": "Memphis Microfinance Bank"
        },
        {
            "id": 2088,
            "code": "090433",
            "name": "Rigo Microfinance Bank"
        },
        {
            "id": 2089,
            "code": "090434",
            "name": "Insight Microfinance Bank"
        },
        {
            "id": 2090,
            "code": "090435",
            "name": "Links Microfinance Bank"
        },
        {
            "id": 2091,
            "code": "090436",
            "name": "Spectrum Microfinance Bank"
        },
        {
            "id": 2092,
            "code": "090437",
            "name": "Oakland Microfinance Bank"
        },
        {
            "id": 2093,
            "code": "090438",
            "name": "Futminna Microfinance Bank"
        },
        {
            "id": 2094,
            "code": "090439",
            "name": "Ibeto  Microfinance Bank"
        },
        {
            "id": 2095,
            "code": "090440",
            "name": "Cherish Microfinance Bank"
        },
        {
            "id": 2096,
            "code": "090441",
            "name": "Giwa Microfinance Bank"
        },
        {
            "id": 2097,
            "code": "090443",
            "name": "Rima Microfinance Bank"
        },
        {
            "id": 2098,
            "code": "090444",
            "name": "Boi Mf Bank"
        },
        {
            "id": 2099,
            "code": "090445",
            "name": "Capstone Mf Bank"
        },
        {
            "id": 2100,
            "code": "090446",
            "name": "Support Mf Bank"
        },
        {
            "id": 2101,
            "code": "090448",
            "name": "Moyofade Mf Bank"
        },
        {
            "id": 2102,
            "code": "090449",
            "name": "Sls  Mf Bank"
        },
        {
            "id": 2103,
            "code": "090450",
            "name": "Kwasu Mf Bank"
        },
        {
            "id": 2104,
            "code": "090451",
            "name": "Atbu  Microfinance Bank"
        },
        {
            "id": 2105,
            "code": "090452",
            "name": "Unilag  Microfinance Bank"
        },
        {
            "id": 2106,
            "code": "090453",
            "name": "Uzondu Mf Bank"
        },
        {
            "id": 2107,
            "code": "090454",
            "name": "Borstal Microfinance Bank"
        },
        {
            "id": 2108,
            "code": "090455",
            "name": "MKOBO MICROFINANCE BANK LTD"
        },
        {
            "id": 2109,
            "code": "090456",
            "name": "Ospoly Microfinance Bank"
        },
        {
            "id": 2110,
            "code": "090459",
            "name": "Nice Microfinance Bank"
        },
        {
            "id": 2111,
            "code": "090460",
            "name": "Oluyole Microfinance Bank"
        },
        {
            "id": 2112,
            "code": "090461",
            "name": "Uniibadan Microfinance Bank"
        },
        {
            "id": 2113,
            "code": "090462",
            "name": "Monarch Microfinance Bank"
        },
        {
            "id": 2114,
            "code": "090463",
            "name": "Rehoboth Microfinance Bank"
        },
        {
            "id": 2115,
            "code": "090464",
            "name": "Unimaid Microfinance Bank"
        },
        {
            "id": 2116,
            "code": "090465",
            "name": "Maintrust Microfinance Bank"
        },
        {
            "id": 2117,
            "code": "090466",
            "name": "Yct Microfinance Bank"
        },
        {
            "id": 2118,
            "code": "090467",
            "name": "Good Neighbours Microfinance Bank"
        },
        {
            "id": 2119,
            "code": "090468",
            "name": "Olofin Owena Microfinance Bank"
        },
        {
            "id": 2120,
            "code": "090469",
            "name": "Aniocha Microfinance Bank"
        },
        {
            "id": 2121,
            "code": "090470",
            "name": "DOT MICROFINANCE BANK"
        },
        {
            "id": 2122,
            "code": "090471",
            "name": "Oluchukwu Microfinance Bank"
        },
        {
            "id": 2123,
            "code": "090472",
            "name": "Caretaker Microfinance Bank"
        },
        {
            "id": 2124,
            "code": "090473",
            "name": "Assets Microfinance Bank"
        },
        {
            "id": 2125,
            "code": "090474",
            "name": "Verdant Microfinance Bank"
        },
        {
            "id": 2126,
            "code": "090475",
            "name": "Giant Stride Microfinance Bank"
        },
        {
            "id": 2127,
            "code": "090476",
            "name": "Anchorage Microfinance Bank"
        },
        {
            "id": 2128,
            "code": "090477",
            "name": "Light Microfinance Bank"
        },
        {
            "id": 2129,
            "code": "090478",
            "name": "Avuenegbe Microfinance Bank"
        },
        {
            "id": 2130,
            "code": "090479",
            "name": "First Heritage Microfinance Bank"
        },
        {
            "id": 2131,
            "code": "090480",
            "name": "Cintrust Microfinance Bank"
        },
        {
            "id": 2132,
            "code": "090481",
            "name": "Prisco  Microfinance Bank"
        },
        {
            "id": 2133,
            "code": "090482",
            "name": "FEDETH MICROFINANCE BANK"
        },
        {
            "id": 2134,
            "code": "090483",
            "name": "Ada Microfinance Bank"
        },
        {
            "id": 2135,
            "code": "090484",
            "name": "Garki Microfinance Bank"
        },
        {
            "id": 2136,
            "code": "090485",
            "name": "Safegate Microfinance Bank"
        },
        {
            "id": 2137,
            "code": "090486",
            "name": "Fortress Microfinance Bank"
        },
        {
            "id": 2138,
            "code": "090487",
            "name": "Kingdom College  Microfinance Bank"
        },
        {
            "id": 2139,
            "code": "090488",
            "name": "Ibu-Aje Microfinance"
        },
        {
            "id": 2140,
            "code": "090489",
            "name": "Alvana Microfinance Bank"
        },
        {
            "id": 2141,
            "code": "090490",
            "name": "Chukwunenye  Microfinance Bank"
        },
        {
            "id": 2142,
            "code": "090491",
            "name": "Nsuk  Microfinance Bank"
        },
        {
            "id": 2143,
            "code": "090492",
            "name": "Oraukwu  Microfinance Bank"
        },
        {
            "id": 2144,
            "code": "090493",
            "name": "Iperu Microfinance Bank"
        },
        {
            "id": 2145,
            "code": "090494",
            "name": "Boji Boji Microfinance Bank"
        },
        {
            "id": 2146,
            "code": "090495",
            "name": "GOODNEWS MFB"
        },
        {
            "id": 2147,
            "code": "090496",
            "name": "Radalpha Microfinance Bank"
        },
        {
            "id": 2148,
            "code": "090497",
            "name": "Palmcoast Microfinance Bank"
        },
        {
            "id": 2149,
            "code": "090498",
            "name": "Catland Microfinance Bank"
        },
        {
            "id": 2150,
            "code": "090499",
            "name": "Pristine Divitis Microfinance Bank"
        },
        {
            "id": 2151,
            "code": "090500",
            "name": "Gwong Microfinance Bank"
        },
        {
            "id": 2152,
            "code": "090501",
            "name": "Boromu Microfinance Bank"
        },
        {
            "id": 2153,
            "code": "090502",
            "name": "Shalom Microfinance Bank"
        },
        {
            "id": 2154,
            "code": "090503",
            "name": "Projects Microfinance Bank"
        },
        {
            "id": 2155,
            "code": "090504",
            "name": "Zikora Microfinance Bank"
        },
        {
            "id": 2156,
            "code": "090505",
            "name": "Nigeria Prisonsmicrofinance Bank"
        },
        {
            "id": 2157,
            "code": "090506",
            "name": "Solid Allianze Microfinance Bank"
        },
        {
            "id": 2158,
            "code": "090507",
            "name": "Fims Microfinance Bank"
        },
        {
            "id": 2159,
            "code": "090508",
            "name": "Borno Renaissance Microfinance Bank"
        },
        {
            "id": 2160,
            "code": "090509",
            "name": "Capitalmetriq Swift Microfinance Bank"
        },
        {
            "id": 2161,
            "code": "090510",
            "name": "Umunnachi Microfinance Bank"
        },
        {
            "id": 2162,
            "code": "090511",
            "name": "Cloverleaf  Microfinance Bank"
        },
        {
            "id": 2163,
            "code": "090512",
            "name": "Bubayero Microfinance Bank"
        },
        {
            "id": 2164,
            "code": "090513",
            "name": "Seap Microfinance Bank"
        },
        {
            "id": 2165,
            "code": "090514",
            "name": "Umuchinemere Procredit Microfinance Bank"
        },
        {
            "id": 2166,
            "code": "090515",
            "name": "Rima Growth Pathway Microfinance Bank "
        },
        {
            "id": 2167,
            "code": "090516",
            "name": "Numo Microfinance Bank"
        },
        {
            "id": 2168,
            "code": "090517",
            "name": "Uhuru Microfinance Bank"
        },
        {
            "id": 2169,
            "code": "090518",
            "name": "Afemai Microfinance Bank"
        },
        {
            "id": 2170,
            "code": "090519",
            "name": "Ibom Fadama Microfinance Bank"
        },
        {
            "id": 2171,
            "code": "090520",
            "name": "Ic Globalmicrofinance Bank"
        },
        {
            "id": 2172,
            "code": "090521",
            "name": "Foresight Microfinance Bank"
        },
        {
            "id": 2173,
            "code": "090523",
            "name": "Chase Microfinance Bank"
        },
        {
            "id": 2174,
            "code": "090524",
            "name": "Solidrock Microfinance Bank"
        },
        {
            "id": 2175,
            "code": "090525",
            "name": "Triple A Microfinance Bank"
        },
        {
            "id": 2176,
            "code": "090526",
            "name": "Crescent Microfinance Bank"
        },
        {
            "id": 2177,
            "code": "090527",
            "name": "Ojokoro Microfinance Bank"
        },
        {
            "id": 2178,
            "code": "090528",
            "name": "Mgbidi Microfinance Bank"
        },
        {
            "id": 2179,
            "code": "090529",
            "name": "Ampersand Microfinance Bank"
        },
        {
            "id": 2180,
            "code": "090530",
            "name": "Confidence Microfinance Bank Ltd"
        },
        {
            "id": 2181,
            "code": "090531",
            "name": "Aku Microfinance Bank"
        },
        {
            "id": 2182,
            "code": "090532",
            "name": "Ibolo Micorfinance Bank Ltd"
        },
        {
            "id": 2183,
            "code": "090534",
            "name": "Polyibadan Microfinance Bank"
        },
        {
            "id": 2184,
            "code": "090535",
            "name": "Nkpolu-Ust Microfinance"
        },
        {
            "id": 2185,
            "code": "090536",
            "name": "Ikoyi-Osun Microfinance Bank"
        },
        {
            "id": 2186,
            "code": "090537",
            "name": "Lobrem Microfinance Bank"
        },
        {
            "id": 2187,
            "code": "090538",
            "name": "Blue Investments Microfinance Bank"
        },
        {
            "id": 2188,
            "code": "090539",
            "name": "Enrich Microfinance Bank"
        },
        {
            "id": 2189,
            "code": "090540",
            "name": "Aztec Microfinance Bank"
        },
        {
            "id": 2190,
            "code": "090541",
            "name": "Excellent Microfinance Bank"
        },
        {
            "id": 2191,
            "code": "090542",
            "name": "Otuo Microfinance Bank Ltd"
        },
        {
            "id": 2192,
            "code": "090543",
            "name": "Iwoama Microfinance Bank"
        },
        {
            "id": 2193,
            "code": "090544",
            "name": "Aspire Microfinance Bank Ltd"
        },
        {
            "id": 2194,
            "code": "090545",
            "name": "Abulesoro Microfinance Bank Ltd"
        },
        {
            "id": 2195,
            "code": "090546",
            "name": "Ijebu-Ife Microfinance Bank Ltd"
        },
        {
            "id": 2196,
            "code": "090547",
            "name": "Rockshield Microfinance Bank"
        },
        {
            "id": 2197,
            "code": "090548",
            "name": "Ally Microfinance Bank"
        },
        {
            "id": 2198,
            "code": "090549",
            "name": "Kc Microfinance Bank"
        },
        {
            "id": 2199,
            "code": "090550",
            "name": "Green Energy Microfinance Bank Ltd"
        },
        {
            "id": 2200,
            "code": "090551",
            "name": "Fairmoney Microfinance Bank Ltd"
        },
        {
            "id": 2201,
            "code": "090552",
            "name": "Ekimogun Microfinance Bank"
        },
        {
            "id": 2202,
            "code": "090553",
            "name": "Consistent Trust Microfinance Bank Ltd"
        },
        {
            "id": 2203,
            "code": "090554",
            "name": "Kayvee Microfinance Bank"
        },
        {
            "id": 2204,
            "code": "090555",
            "name": "Bishopgate Microfinance Bank"
        },
        {
            "id": 2205,
            "code": "090556",
            "name": "Egwafin Microfinance Bank Ltd"
        },
        {
            "id": 2206,
            "code": "090557",
            "name": "Lifegate Microfinance Bank Ltd"
        },
        {
            "id": 2207,
            "code": "090558",
            "name": "Shongom Microfinance Bank Ltd"
        },
        {
            "id": 2208,
            "code": "090559",
            "name": "Shield Microfinance Bank Ltd"
        },
        {
            "id": 2209,
            "code": "090560",
            "name": "TANADI MFB (CRUST)"
        },
        {
            "id": 2210,
            "code": "090561",
            "name": "Akuchukwu Microfinance Bank Ltd"
        },
        {
            "id": 2211,
            "code": "090562",
            "name": "Cedar Microfinance Bank Ltd"
        },
        {
            "id": 2212,
            "code": "090563",
            "name": "Balera Microfinance Bank Ltd"
        },
        {
            "id": 2213,
            "code": "090564",
            "name": "Supreme Microfinance Bank Ltd"
        },
        {
            "id": 2214,
            "code": "090565",
            "name": "Oke-Aro Oredegbe Microfinance Bank Ltd"
        },
        {
            "id": 2215,
            "code": "090566",
            "name": "Okuku Microfinance Bank Ltd"
        },
        {
            "id": 2216,
            "code": "090567",
            "name": "Orokam Microfinance Bank Ltd"
        },
        {
            "id": 2217,
            "code": "090568",
            "name": "Broadview Microfinance Bank Ltd"
        },
        {
            "id": 2218,
            "code": "090569",
            "name": "Qube Microfinance Bank Ltd"
        },
        {
            "id": 2219,
            "code": "090570",
            "name": "Iyamoye Microfinance Bank Ltd"
        },
        {
            "id": 2220,
            "code": "090571",
            "name": "Ilaro Poly Microfinance Bank Ltd"
        },
        {
            "id": 2221,
            "code": "090572",
            "name": "Ewt Microfinance Bank"
        },
        {
            "id": 2222,
            "code": "090573",
            "name": "Snow Microfinance Bank"
        },
        {
            "id": 2223,
            "code": "090574",
            "name": "GOLDMAN MICROFINANCE BANK"
        },
        {
            "id": 2224,
            "code": "090575",
            "name": "Firstmidas Microfinance Bank Ltd"
        },
        {
            "id": 2225,
            "code": "090576",
            "name": "Octopus Microfinance Bank Ltd"
        },
        {
            "id": 2226,
            "code": "090578",
            "name": "Iwade Microfinance Bank Ltd"
        },
        {
            "id": 2227,
            "code": "090579",
            "name": "Gbede Microfinance Bank"
        },
        {
            "id": 2228,
            "code": "090580",
            "name": "Otech Microfinance Bank Ltd"
        },
        {
            "id": 2229,
            "code": "090581",
            "name": "BANC CORP MICROFINANCE BANK"
        },
        {
            "id": 2230,
            "code": "090583",
            "name": "STATESIDE MFB"
        },
        {
            "id": 2231,
            "code": "090584",
            "name": "ISLAND MICROFINANCE BANK "
        },
        {
            "id": 2232,
            "code": "090586",
            "name": "GOMBE MICROFINANCE BANK LTD"
        },
        {
            "id": 2233,
            "code": "090587",
            "name": "Microbiz Microfinance Bank"
        },
        {
            "id": 2234,
            "code": "090588",
            "name": "Orisun MFB"
        },
        {
            "id": 2235,
            "code": "090589",
            "name": "Mercury MFB"
        },
        {
            "id": 2236,
            "code": "090590",
            "name": "WAYA MICROFINANCE BANK LTD"
        },
        {
            "id": 2237,
            "code": "090591",
            "name": "Gabsyn Microfinance Bank"
        },
        {
            "id": 2238,
            "code": "090592",
            "name": "KANO POLY MFB"
        },
        {
            "id": 2239,
            "code": "090593",
            "name": "TASUED MICROFINANCE BANK LTD"
        },
        {
            "id": 2240,
            "code": "090598",
            "name": "IBA MFB "
        },
        {
            "id": 2241,
            "code": "090599",
            "name": "Greenacres MFB"
        },
        {
            "id": 2242,
            "code": "090600",
            "name": "AVE MARIA MICROFINANCE BANK LTD"
        },
        {
            "id": 2243,
            "code": "090602",
            "name": "KENECHUKWU MICROFINANCE BANK"
        },
        {
            "id": 2244,
            "code": "090603 ",
            "name": "Macrod MFB"
        },
        {
            "id": 2245,
            "code": "090606",
            "name": "KKU Microfinance Bank"
        },
        {
            "id": 2246,
            "code": "090608",
            "name": "Akpo Microfinance Bank"
        },
        {
            "id": 2247,
            "code": "090609",
            "name": "Ummah Microfinance Bank "
        },
        {
            "id": 2248,
            "code": "090610",
            "name": "AMOYE MICROFINANCE BANK"
        },
        {
            "id": 2249,
            "code": "090611",
            "name": "Creditville Microfinance Bank"
        },
        {
            "id": 2250,
            "code": "090612",
            "name": "Medef Microfinance Bank"
        },
        {
            "id": 2251,
            "code": "090613",
            "name": "Total Trust Microfinance Bank"
        },
        {
            "id": 2252,
            "code": "090614",
            "name": "FLOURISH MFB"
        },
        {
            "id": 2253,
            "code": "090615",
            "name": "Beststar Microfinance Bank"
        },
        {
            "id": 2254,
            "code": "090616",
            "name": "RAYYAN Microfinance Bank"
        },
        {
            "id": 2255,
            "code": "090620",
            "name": "Iyin Ekiti MFB"
        },
        {
            "id": 2256,
            "code": "090621",
            "name": "GIDAUNIYAR ALHERI MICROFINANCE BANK"
        },
        {
            "id": 2257,
            "code": "090623",
            "name": "Mab Allianz MFB"
        },
        {
            "id": 2258,
            "code": "100001",
            "name": "FET"
        },
        {
            "id": 2259,
            "code": "100003",
            "name": "Parkway-ReadyCash"
        },
        {
            "id": 2260,
            "code": "100004",
            "name": "Opay"
        },
        {
            "id": 2261,
            "code": "100005",
            "name": "Cellulant"
        },
        {
            "id": 2262,
            "code": "100006",
            "name": "eTranzact"
        },
        {
            "id": 2263,
            "code": "100007",
            "name": "Stanbic IBTC @ease wallet"
        },
        {
            "id": 2264,
            "code": "100008",
            "name": "Ecobank Xpress Account"
        },
        {
            "id": 2265,
            "code": "100009",
            "name": "GTMobile"
        },
        {
            "id": 2266,
            "code": "100010",
            "name": "TeasyMobile"
        },
        {
            "id": 2267,
            "code": "100011",
            "name": "Mkudi"
        },
        {
            "id": 2268,
            "code": "100012",
            "name": "VTNetworks"
        },
        {
            "id": 2269,
            "code": "100013",
            "name": "AccessMobile"
        },
        {
            "id": 2270,
            "code": "100014",
            "name": "FBNMobile"
        },
        {
            "id": 2271,
            "code": "100015",
            "name": "Kegow"
        },
        {
            "id": 2272,
            "code": "100016",
            "name": "FortisMobile"
        },
        {
            "id": 2273,
            "code": "100017",
            "name": "Hedonmark"
        },
        {
            "id": 2274,
            "code": "100018",
            "name": "ZenithMobile"
        },
        {
            "id": 2275,
            "code": "100019",
            "name": "Fidelity Mobile"
        },
        {
            "id": 2276,
            "code": "100020",
            "name": "MoneyBox"
        },
        {
            "id": 2277,
            "code": "100021",
            "name": "Eartholeum"
        },
        {
            "id": 2278,
            "code": "100022",
            "name": "GoMoney"
        },
        {
            "id": 2279,
            "code": "100023",
            "name": "TagPay"
        },
        {
            "id": 2280,
            "code": "100024",
            "name": "Imperial Homes Mortgage Bank"
        },
        {
            "id": 2281,
            "code": "100025",
            "name": "Zinternet Nigera Limited"
        },
        {
            "id": 2282,
            "code": "100026",
            "name": "One Finance"
        },
        {
            "id": 2283,
            "code": "100027",
            "name": "Intellifin"
        },
        {
            "id": 2284,
            "code": "100028",
            "name": "AG Mortgage Bank"
        },
        {
            "id": 2285,
            "code": "100029",
            "name": "Innovectives Kesh"
        },
        {
            "id": 2286,
            "code": "100030",
            "name": "EcoMobile"
        },
        {
            "id": 2287,
            "code": "100031",
            "name": "FCMB Easy Account"
        },
        {
            "id": 2288,
            "code": "100032",
            "name": "Contec Global Infotech Limited (NowNow)"
        },
        {
            "id": 2289,
            "code": "100033",
            "name": "PALMPAY"
        },
        {
            "id": 2290,
            "code": "100034",
            "name": "Zwallet"
        },
        {
            "id": 2291,
            "code": "100035",
            "name": "M36"
        },
        {
            "id": 2292,
            "code": "100036",
            "name": "Kegow(Chamsmobile)"
        },
        {
            "id": 2293,
            "code": "100039",
            "name": "Titan-Paystack"
        },
        {
            "id": 2294,
            "code": "100052",
            "name": "Beta-Access Yello"
        },
        {
            "id": 2295,
            "code": "101",
            "name": "ProvidusBank PLC"
        },
        {
            "id": 2296,
            "code": "110001",
            "name": "PayAttitude Online"
        },
        {
            "id": 2297,
            "code": "110002",
            "name": "Flutterwave Technology Solutions Limited"
        },
        {
            "id": 2298,
            "code": "110003",
            "name": "Interswitch Limited"
        },
        {
            "id": 2299,
            "code": "110004",
            "name": "First Apple Limited"
        },
        {
            "id": 2300,
            "code": "110005",
            "name": "3Line Card Management Limited"
        },
        {
            "id": 2301,
            "code": "110006",
            "name": "Paystack Payments Limited"
        },
        {
            "id": 2302,
            "code": "110007",
            "name": "TeamApt"
        },
        {
            "id": 2303,
            "code": "110008",
            "name": "Kadick Integration Limited"
        },
        {
            "id": 2304,
            "code": "110009",
            "name": "Venture Garden Nigeria Limited"
        },
        {
            "id": 2305,
            "code": "110010",
            "name": "Interswitch Financial Inclusion Services (Ifis)"
        },
        {
            "id": 2306,
            "code": "110011",
            "name": "Arca Payments"
        },
        {
            "id": 2307,
            "code": "110012",
            "name": "Cellulant Pssp"
        },
        {
            "id": 2308,
            "code": "110013",
            "name": "Qr Payments"
        },
        {
            "id": 2309,
            "code": "110014",
            "name": "Cyberspace Limited"
        },
        {
            "id": 2310,
            "code": "110015",
            "name": "Vas2Nets Limited"
        },
        {
            "id": 2311,
            "code": "110017",
            "name": "Crowdforce"
        },
        {
            "id": 2312,
            "code": "110018",
            "name": "Microsystems Investment And Development Limited"
        },
        {
            "id": 2313,
            "code": "110019",
            "name": "Nibssussd Payments"
        },
        {
            "id": 2314,
            "code": "110021",
            "name": "Bud Infrastructure Limited"
        },
        {
            "id": 2315,
            "code": "110022",
            "name": "Koraypay"
        },
        {
            "id": 2316,
            "code": "110023",
            "name": "Capricorn Digital"
        },
        {
            "id": 2317,
            "code": "110024",
            "name": "Resident Fintech Limited"
        },
        {
            "id": 2318,
            "code": "110025",
            "name": "Netapps Technology Limited"
        },
        {
            "id": 2319,
            "code": "110026",
            "name": "Spay Business"
        },
        {
            "id": 2320,
            "code": "110027",
            "name": "Yello Digital Financial Services"
        },
        {
            "id": 2321,
            "code": "110028",
            "name": "Nomba Financial Services Limited"
        },
        {
            "id": 2322,
            "code": "110029",
            "name": "Woven Finance"
        },
        {
            "id": 2323,
            "code": "110044",
            "name": "Leadremit Limited"
        },
        {
            "id": 2324,
            "code": "120001",
            "name": "9 Payment Service Bank"
        },
        {
            "id": 2325,
            "code": "120002",
            "name": "Hopepsb"
        },
        {
            "id": 2326,
            "code": "120003",
            "name": "Momo Psb"
        },
        {
            "id": 2327,
            "code": "120004",
            "name": "Smartcash Payment Service Bank"
        },
        {
            "id": 2328,
            "code": "120005",
            "name": "Money Master Psb"
        },
        {
            "id": 2329,
            "code": "400001",
            "name": "FSDH Merchant Bank"
        },
        {
            "id": 2330,
            "code": "502",
            "name": "Rand merchant Bank"
        },
        {
            "id": 2331,
            "code": "608",
            "name": "FINATRUST MICROFINANCE BANK"
        },
        {
            "id": 2332,
            "code": "999001",
            "name": "CBN_TSA"
        },
        {
            "id": 2333,
            "code": "999999",
            "name": "NIP Virtual Bank"
        }
    ]

    const submitInvoice = () => {
        const loadedItems = localStorage.getItem("savedItems");
        let totalSum = 0;
        document.getElementById("items").value = loadedItems;
        if (loadedItems) {
            const theData = JSON.parse(loadedItems);
            for (let index = 0; index < theData.length; index++) {
                totalSum = totalSum + theData[index].amount;
            }
        }
        document.getElementById("sumAmount").value = totalSum;
        document.getElementById("invoiceForm").submit();
        localStorage.delete("savedItems");
    }

    $(document).ready(function() {
        bankList.forEach(bank => {
            $("#bankName").append($('<option>', {
                value: `${bank.code}|${bank.name}`,
                text: bank.name
            }));
        });

    });
</script>
@stop