@extends('layouts.auth',["title"=>"login", "state"=>0, "showSteps"=> 0])
@section('content')
<div class="w-full mt-6 lg:mt-12">
    <div class="w-full px-8">
        <div class="title">
            <div class="create-account3">Welcome Back</div>
        </div>
        <form id="loginform" class="frame-167" method="post" action="/login">
            @if(count($errors) > 0 )

            <ul class="" style="list-style: none;">
                @foreach($errors->all() as $error)
                <li>
                    <div class="p-4 mb-4 text-sm text-red-800 rounded-lg bg-red-50 dark:bg-gray-800 dark:text-red-400" role="alert">
                        <span class="font-medium">{{$error}}</span>
                    </div>
                </li>
                @endforeach
            </ul>

            @endif
            @csrf
            <div class="mb-2 w-full">
                <label for="emailPhone" class="block mb-2 lable dark:text-white">Email / Phone</label>
                <input type="text" id="emailPhone" name="emailPhone" value="{{old('emailPhone')}}" placeholder="Enter your email" class="block w-full p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
            </div>

            <div class="mb-2 w-full">
                <label for="password" class="block mb-2 lable dark:text-white">Password</label>
                <input type="password" id="password" name="password" value="{{old('password')}}" placeholder="Enter password" class="block w-full p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
            </div>

        </form>
    </div>
    <div class="flex justify-between mx-8">
        <div> Do not have an account?<a href="/register" class="text-yellow-500"> Sign Up </a></div>
        <div> forgot password<a href="#" class="text-yellow-500"> Reset now </a></div>

    </div>
    <div class="arrows mt-8 px-8">
        <button onclick="submiteForm()" type="button" class="button">
            <div class="next">Login</div>
            <img class="arrow-right" src="/icons/Arrow-right.png" />
        </button>
    </div>

</div>
<script>
    const submiteForm = () => {
        document.getElementById("loginform").submit();
    }
</script>
@stop