<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('firstName');
            $table->string('lastName');
            $table->string('email')->unique()->nullable();
            $table->string('phone')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->timestamp('phone_verified_at')->nullable();
            $table->longText('img')->nullable();
            $table->longText('address')->nullable();
            $table->enum('type', ["user", "vendor", "client", "staff", "student"])->default("user");
            $table->enum('gender', ["male", "female", "other"])->default("female");
            $table->enum('maritalStatus', ["divorced", "married", "separated ", "single"])->default("single");
            $table->date('dob')->nullable();
            $table->string('bloodGroup')->nullable();
            $table->string('genotype')->nullable();
            $table->string('medicalCon')->nullable();
            $table->enum('status', ["pending", "active", "suspended"])->default("pending");
            $table->string('lga')->nullable();
            $table->string('state')->nullable();
            $table->string('country')->nullable()->default("NGN");
            $table->string('position')->nullable();
            $table->string('training')->nullable();
            $table->enum('religion', ["christianity", "islam ", "judaism", "others"])->default("others");
            $table->double('height')->nullable();
            $table->double('weight')->nullable();
            $table->string('password');
            $table->rememberToken();
            $table->timestamps();
        });

        Schema::create('password_reset_tokens', function (Blueprint $table) {
            $table->string('email')->primary();
            $table->string('token');
            $table->timestamp('created_at')->nullable();
        });

        Schema::create('sessions', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->foreignId('user_id')->nullable()->index();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->longText('payload');
            $table->integer('last_activity')->index();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
        Schema::dropIfExists('password_reset_tokens');
        Schema::dropIfExists('sessions');
    }
};
