@extends('layouts.auth',["title"=>"login", "state"=>2, "showSteps"=> 1])
@section('content')
<div class="w-full mt-6 lg:mt-12">
    <div class="w-full px-8">
        <div class="title">
            <div class="create-account3">Personal Info</div>
        </div>
        <form class="frame-167" id="personalInfoform" method="post" action="/personal-info">
            @if(count($errors) > 0 )

            <ul class="" style="list-style: none;">
                @foreach($errors->all() as $error)
                <li>
                    <div class="p-4 mb-4 text-sm text-red-800 rounded-lg bg-red-50 dark:bg-gray-800 dark:text-red-400" role="alert">
                        <span class="font-medium">{{$error}}</span>
                    </div>
                </li>
                @endforeach
            </ul>

            @endif
            @csrf
            <div class="mb-2 w-full">
                <label for="homeAddress" class="block mb-2 lable dark:text-white">Home Address</label>
                <input type="text" id="homeAddress" name="homeAddress" value="{{old('homeAddress')}}" placeholder="Enter your residential address" class="block w-full p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
            </div>
            <div class="flex flex-wrap mb-2 w-full">
                <div class="w-full md:w-1/2 px-1 mb-2 md:mb-0">
                    <label class="block mb-2 lable dark:text-white" for="state">
                        State of Origin
                    </label>
                    <select onchange="handleStateChange()" class="block w-full p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" id="state" name="state" type="text" placeholder="Jane">
                        <option selected>Select State</option>
                    </select>
                </div>
                <div class="w-full md:w-1/2 px-1">
                    <label class="block mb-2 lable dark:text-white" for="lga">
                        L.G.A
                    </label>
                    <select class="block w-full p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" id="lga" name="lga" type="text" placeholder="Jane">
                        <option selected>Select L.G.A</option>
                    </select>
                </div>
            </div>
            <div class="flex flex-wrap mb-2 w-full">
                <div class="w-full md:w-1/2 px-1 mb-2 md:mb-0">
                    <label class="block mb-2 lable dark:text-white" for="gender">
                        Gender
                    </label>
                    <select class="block w-full p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" id="gender" name="gender" type="text" placeholder="Jane">
                        <option selected>Select Gender</option>
                        <option>Male</option>
                        <option>Female</option>
                    </select>
                </div>
                <div class="w-full md:w-1/2 px-1">
                    <label class="block mb-2 lable dark:text-white" for="dob">
                        Date of Birth
                    </label>
                    <input class="block w-full p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" id="dob" name="dob" type="date">
                </div>
            </div>
            <div class="flex flex-wrap mb-2 w-full">
                <div class="w-full md:w-1/2 px-1 mb-2 md:mb-0">
                    <label class="block mb-2 lable dark:text-white" for="height">
                        Height
                    </label>
                    <input class="block w-full p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" id="height" name="height" type="number" placeholder="Enter your Height in foot">
                </div>
                <div class="w-full md:w-1/2 px-1">
                    <label class="block mb-2 lable dark:text-white" for="weight">
                        Weight
                    </label>
                    <input class="block w-full p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" id="weight" name="weight" type="number" placeholder="Enter your weight in KG">
                </div>
            </div>
            <div class="flex flex-wrap mb-2 w-full">
                <div class="w-full md:w-1/2 px-1 mb-2 md:mb-0">
                    <label class="block mb-2 lable dark:text-white" for="religion">
                        Religion
                    </label>
                    <select class="block w-full p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" id="religion" name="religion" type="text" placeholder="Jane">
                        <option selected>Select Religion</option>
                        <option value="christianity">Christianity</option>
                        <option value="islam">Islam</option>
                        <option value="judaism">Judaism</option>
                        <option value="others">Others</option>
                    </select>
                </div>
                <div class="w-full md:w-1/2 px-1">
                    <label class="block mb-2 lable dark:text-white" for="maritalStatus">
                        Marital status
                    </label>
                    <select class="block w-full p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" id="maritalStatus" name="maritalStatus" type="text" placeholder="Jane">
                        <option selected>Select Marital status</option>
                        <option value="single">Single</option>
                        <option value="married">Married</option>
                        <option value="divorced">Divorced</option>
                        <option value="separated">Separated</option>
                    </select>

                </div>
            </div>
            <div class="flex flex-wrap mb-2 w-full">
                <div class="w-full md:w-1/2 px-1 mb-2 md:mb-0">
                    <label class="block mb-2 lable dark:text-white" for="bloodGroup">
                        Blood group
                    </label>
                    <select class="block w-full p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" id="bloodGroup" name="bloodGroup" type="text" placeholder="Jane">
                        <option selected>Select Blood group</option>
                        <option value="A+">A+</option>
                        <option value="A-">A-</option>
                        <option value="B+">B+</option>
                        <option value="B-">B-</option>
                        <option value="O+">O+</option>
                        <option value="O-">O-</option>
                        <option value="AB+">AB+</option>
                        <option value="AB-">AB-</option>
                    </select>
                </div>
                <div class="w-full md:w-1/2 px-1">
                    <label class="block mb-2 lable dark:text-white" for="genotype">
                        Genotype
                    </label>
                    <select class="block w-full p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" id="genotype" name="genotype" type="text" placeholder="Jane">
                        <option selected>Select Genotype</option>
                        <option value="AA">AA</option>
                        <option value=" AS"> AS</option>
                        <option value="AC">AC</option>
                        <option value="CC">CC</option>
                        <option value="SC">SC</option>
                        <option value="SS">SS</option>
                    </select>

                </div>
            </div>
            <div class="mb-2 w-full">
                <label for="medicalCon" class="block mb-2 lable dark:text-white">Special medical needs</label>
                <input type="text" id="medicalCon" name="medicalCon" placeholder="Any special medical condition please type" class="block w-full p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
            </div>
        </form>
    </div>

    <div class="arrows2 mt-8 px-8">
        <a href="/register" class="buttonPre">
            <img class="arrow-right" src="/icons/Arrow-left.png" />
            <div class="next">Previous</div>
        </a>
        <button onclick="submiteForm()" class="button">
            <div class="next">Next</div>
            <img class="arrow-right" src="/icons/Arrow-right.png" />
        </button>
    </div>
</div>

<script>
    const submiteForm = () => {
        document.getElementById("personalInfoform").submit();
    }
    async function fetchAsync(url) {
        let response = await fetch(url);
        let data = await response.json();
        return data;
    }

    function removeOptions(selectElement) {
        var i, L = selectElement.options.length - 1;
        for (i = L; i >= 0; i--) {
            selectElement.remove(i);
        }
    }

    const loadStateData = async () => {
        const stateData = await fetchAsync("/state-lag");
        localStorage.setItem("rawState", JSON.stringify(stateData));
        $(document).ready(function() {
            Object.keys(stateData).forEach(sta => {
                $("#state").append($('<option>', {
                    value: sta,
                    text: sta
                }));
            });

        });
        $(document).ready(function() {

            stateData["Abia"].forEach(lga => {
                $("#lga").append($('<option>', {
                    value: lga,
                    text: lga
                }));
            });

        });
    }

    loadStateData();

    const handleStateChange = () => {
        removeOptions(document.getElementById('lga'));
        const rawState = JSON.parse(localStorage.getItem("rawState"));
        const newState = document.getElementById("state").value;
        $(document).ready(function() {
            rawState[newState].forEach(lga => {
                $("#lga").append($('<option>', {
                    value: lga,
                    text: lga
                }));
            });

        });
    }
</script>
@stop