
<?php $__env->startSection('statusmenue'); ?>
<div class="lg:flex lg:flex-row px-4 mt-4 w-full">


    <div class="w-full lg:w-1/4 md:w-full mx-2 p-6 bg-white border border-gray-200 rounded-lg shadow-sm dark:bg-gray-800 dark:border-gray-700">

        <img class="w-14 h-14 text-gray-500 dark:text-gray-400 mb-3 border-2 border-solid rounded-xl border-gray-300" src="/icons/breafecase.png" />
        <p class="mb-3 font-normal text-gray-500 dark:text-gray-400">Total Users</p>

        <h5 class=" mt-6 text-2xl font-semibold tracking-tight text-gray-900 dark:text-white"><?php echo e($totalUser); ?></h5>

    </div>



    <div class="w-full lg:w-1/4 mx-2 p-6 bg-white border border-gray-200 rounded-lg shadow-sm dark:bg-gray-800 dark:border-gray-700">

        <img class="w-14 h-14 text-gray-500 dark:text-gray-400 mb-3 border-2 border-solid rounded-xl border-gray-300" src="/icons/chear.png" />
        <p class="mb-3 font-normal text-gray-500 dark:text-gray-400">Total Client</p>

        <h5 class=" mt-6 text-2xl font-semibold tracking-tight text-gray-900 dark:text-white"><?php echo e($totalClient); ?></h5>

    </div>




    <div class="w-full lg:w-1/4 mx-2 p-6 bg-white border border-gray-200 rounded-lg shadow-sm dark:bg-gray-800 dark:border-gray-700">
        <img class="w-14 h-14 text-gray-500 dark:text-gray-400 mb-3 border-2 border-solid rounded-xl border-gray-300" src="/icons/alert.png" />

        <p class="mb-3 font-normal text-gray-500 dark:text-gray-400">Total Workforce</p>

        <h5 class=" mt-6 text-2xl font-semibold tracking-tight text-gray-900 dark:text-white"><?php echo e($totalStaff); ?></h5>

    </div>




    <div class="w-full lg:w-1/4 mx-2 p-6 bg-white border border-gray-200 rounded-lg shadow-sm dark:bg-gray-800 dark:border-gray-700">
        <img class="w-14 h-14 text-gray-500 dark:text-gray-400 mb-3 border-2 border-solid rounded-xl border-gray-300" src="/icons/clock2.png" />

        <p class="mb-3 font-normal text-gray-500 dark:text-gray-400">New Student</p>


        <h5 class=" mt-6 text-2xl font-semibold tracking-tight text-gray-900 dark:text-white"><?php echo e($totalStusent); ?></h5>


    </div>

</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="w-full mt-4 relative  shadow-md sm:rounded-lg overflow-auto ">

    <div class="w-full mt-4 relative  shadow-md sm:rounded-lg overflow-auto ">
        <div class="flex items-center justify-between flex-column flex-wrap md:flex-row space-y-4 md:space-y-0 pb-4 bg-white dark:bg-gray-900">

            <div class="mt-2 mx-4">
                <div class="Imprest">
                    Users
                </div>
                <div class="pettyCash">
                    You can search any user or personal
                </div>
            </div>
            <div class="mt-2 mx-4">
                <label for="table-search" class="sr-only">Search</label>
                <div class="relative">
                    <div class="absolute inset-y-0 rtl:inset-r-0 start-0 flex items-center ps-3 pointer-events-none">
                        <svg class="w-4 h-4 text-gray-500 dark:text-gray-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m19 19-4-4m0-7A7 7 0 1 1 1 8a7 7 0 0 1 14 0Z" />
                        </svg>
                    </div>
                    <input type="text" id="table-search-users" class="block p-2 ps-10 text-sm text-gray-900 border border-gray-300 rounded-lg bg-gray-50 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="Search for users">
                </div>
            </div>
        </div>
        <table class="w-full text-sm text-left rtl:text-right text-gray-500 dark:text-gray-400">
            <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                <tr>

                    <th scope="col" class="px-6 py-3">
                        Name/ Type
                    </th>
                    <th scope="col" class="px-6 py-3">
                        Phone/ Email
                    </th>
                    <th scope="col" class="px-6 py-3">
                        Status
                    </th>
                    <th scope="col" class="px-6 py-3">
                        Country/ State
                    </th>
                    <th scope="col" class="px-6 py-3">
                        Action
                    </th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="bg-white border-b dark:bg-gray-800 dark:border-gray-700 border-gray-200 hover:bg-gray-50 dark:hover:bg-gray-600">

                    <th scope="row" class="flex items-center px-6 py-4 text-gray-900 whitespace-nowrap dark:text-white">
                        <a href="/admin/profile/<?php echo e($user->id); ?>" class="">
                            <img class="w-10 h-10 rounded-full" src="<?php echo e(asset($user->img)); ?>" alt="<?php echo e($user->id); ?>">
                        </a>

                        <a href="/admin/profile/<?php echo e($user->id); ?>" class="">
                            <div class="ps-3">
                                <div class="text-base font-semibold"><?php echo e($user->firstName); ?> <?php echo e($user->lastName); ?></div>
                                <div class="font-normal text-gray-500"><?php echo e($user->type); ?></div>
                            </div>
                        </a>
                    </th>
                    <td class="px-6 py-4">
                        <a href="/admin/profile/<?php echo e($user->id); ?>" class="">
                            <div class="text-base font-semibold"><?php echo e($user->phone); ?></div>
                            <div class="font-normal text-gray-500"><?php echo e($user->email); ?></div>
                        </a>

                    </td>
                    <td class="px-6 py-4">
                        <div class="flex items-center">
                            <?php if($user->phone_verified_at): ?>
                            <div class="h-2.5 w-2.5 rounded-full bg-green-500 me-2"></div> verified
                            <?php else: ?>
                            <div class="h-2.5 w-2.5 rounded-full bg-red-500 me-2"></div> unverified
                            <?php endif; ?>
                        </div>
                        <div class="flex items-center">
                            <?php if($user->email_verified_at): ?>
                            <div class="h-2.5 w-2.5 rounded-full bg-green-500 me-2"></div> verified
                            <?php else: ?>
                            <div class="h-2.5 w-2.5 rounded-full bg-red-500 me-2"></div> unverified
                            <?php endif; ?>
                        </div>
                    </td>
                    <td class="px-6 py-4">
                        <div class="text-base font-semibold"><?php echo e($user->country); ?></div>
                        <div class="font-normal text-gray-500"><?php echo e($user->state); ?></div>
                    </td>
                    <td class="flex px-6 py-4">
                        <?php if($user->status==="pending"): ?>
                        <form action="/admin/users-approve" method="post">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="userId" value="<?php echo e($user->id); ?>">
                            <button type="submit" title="Approve user" class="mx-1 h-10 w-10 bg-green-100 rounded-lg hover:bg-green-200 flex justify-center items-center">
                                <img class="h-5 w-5 rounded-lg" src="/icons/check-green.png" alt="" srcset="">
                            </button>
                        </form>
                        <?php endif; ?>
                        <button type="button" onclick='showUserModal("<?php echo e($user->id); ?>")' class="mx-1 h-10 w-10 bg-gray-100 rounded-lg hover:bg-blue-200">
                            <img class="h-10 w-10 rounded-lg" src="/icons/ButtonSettings.png" alt="" srcset="">
                        </button>
                        <div id="userModal<?php echo e($user->id); ?>" tabindex="-1" class="hidden bg-gray-800 bg-opacity-70 flex overflow-y-auto overflow-x-hidden fixed top-0  z-50 justify-center  w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
                            <div class="relative p-4 w-full max-w-md max-h-full">
                                <!-- Modal content -->
                                <div class="relative bg-white rounded-lg shadow-sm dark:bg-gray-700">
                                    <!-- Modal header -->
                                    <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t dark:border-gray-600 border-gray-200">
                                        <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                                            Assign Staff
                                        </h3>
                                        <button type="button" class="end-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white" data-modal-hide="authentication-modal">
                                            <svg class="w-3 h-3" onclick='showUserModal("<?php echo e($user->id); ?>")' xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                                            </svg>
                                            <span class="sr-only">Close modal</span>
                                        </button>
                                    </div>
                                    <!-- Modal body -->
                                    <div class="p-4 md:p-5">
                                        <form class="space-y-4" action="/admin/deployments" method="post">
                                            <?php if(count($errors) > 0 ): ?>
                                            <ul class="" style="list-style: none;">
                                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li>
                                                    <div class="p-4 mb-4 text-sm text-red-800 rounded-lg bg-red-50 dark:bg-gray-800 dark:text-red-400" role="alert">
                                                        <span class="font-medium"><?php echo e($error); ?></span>
                                                    </div>
                                                </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                            <?php endif; ?>
                                            <?php echo csrf_field(); ?>

                                            <input type="hidden" name="userID" value="<?php echo e($user->id); ?>">
                                            <div class="grid md:grid-cols-2 md:gap-6">
                                                <div class="relative z-0 w-full mb-5 group">
                                                    <select type="text" id="branchId" name="branchId" class="block py-2.5  px-2.5 px-0 w-full text-sm text-gray-900 bg-transparent border-0 border-b-2 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required>
                                                        <option selected>Select Branch</option>
                                                        <?php if(count($theBranchs) > 0 ): ?>
                                                        <?php $__currentLoopData = $theBranchs->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $theBranch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($theBranch->id); ?>"><?php echo e($theBranch->name); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php endif; ?>
                                                    </select>
                                                    <label for="branchId" class="peer-focus:font-medium absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-6 scale-75 top-3 -z-10 origin-[0] peer-focus:start-0 rtl:peer-focus:translate-x-1/4 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:translate-y-0 peer-focus:scale-75 peer-focus:-translate-y-6">Branch Office</label>
                                                </div>
                                                <div class="relative z-0 w-full mb-5 group">
                                                    <select type="text" id="unitId" name="unitId" class="block py-2.5 px-2.5 px-0 w-full text-sm text-gray-900 bg-transparent border-0 border-b-2 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required>
                                                        <option selected>Select Unit</option>
                                                        <?php if(count($theUnits) > 0 ): ?>
                                                        <?php $__currentLoopData = $theUnits->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $theUnit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($theUnit->id); ?>"><?php echo e($theUnit->name); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php endif; ?>
                                                    </select>
                                                    <label for="unitId" class="peer-focus:font-medium absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-6 scale-75 top-3 -z-10 origin-[0] peer-focus:start-0 rtl:peer-focus:translate-x-1/4 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:translate-y-0 peer-focus:scale-75 peer-focus:-translate-y-6">Unit</label>
                                                </div>
                                            </div>
                                            <div class="grid md:grid-cols-2 md:gap-6">
                                                <div class="relative z-0 w-full mb-5 group">
                                                    <select type="text" id="positions" name="positions" class="block py-2.5  px-2.5 px-0 w-full text-sm text-gray-900 bg-transparent border-0 border-b-2 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required>
                                                        <option selected>Select Positions</option>
                                                        <option value="guard">Guard</option>
                                                        <option value="super">Super</option>
                                                        <option value="admin">Admin</option>
                                                    </select>
                                                    <label for="positions" class="peer-focus:font-medium absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-6 scale-75 top-3 -z-10 origin-[0] peer-focus:start-0 rtl:peer-focus:translate-x-1/4 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:translate-y-0 peer-focus:scale-75 peer-focus:-translate-y-6">positions</label>
                                                </div>
                                                <!-- <div class="relative z-0 w-full mb-5 group">
                                                    <input type="tel" id="phone" name="phone" class="block py-2.5 px-2.5 px-0 w-full text-sm text-gray-900 bg-transparent border-0 border-b-2 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required />

                                                    <label for="phone" class="peer-focus:font-medium absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-6 scale-75 top-3 -z-10 origin-[0] peer-focus:start-0 rtl:peer-focus:translate-x-1/4 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:translate-y-0 peer-focus:scale-75 peer-focus:-translate-y-6">Phone</label>
                                                </div> -->
                                            </div>
                                            <div class="text-sm font-medium text-yellow-500 dark:text-yellow-300">
                                                By assigning this personnel to this unit, you agree to send a notification message to this staff member, which will carry legal obligations.
                                            </div>
                                            <button type="submit" class="w-full text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">Assign now</button>

                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <button class="mx-1 h-10 w-10 bg-gray-100 rounded-lg hover:bg-yellow-200">
                            <img class="h-10 w-10 rounded-lg" src="/icons/ButtonEdit.png" alt="" srcset="">
                        </button>
                        <button class="mx-1 h-10 w-10 bg-gray-100 rounded-lg hover:bg-red-200">
                            <img class="h-10 w-10 rounded-lg" src="/icons/lock-open.png" alt="" srcset="">
                        </button>
                        <button class="mx-1 h-10 w-10 bg-gray-100 rounded-lg hover:bg-gray-200">
                            <img class="h-10 w-10 rounded-lg" src="/icons/ButtonTrash.png" alt="" srcset="">
                        </button>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </tbody>

        </table>
        <nav class="flex flex-col md:flex-row justify-between items-start md:items-center space-y-3 md:space-y-0 p-4" aria-label="Table navigation">
            <!-- <span class="text-sm font-normal text-gray-500 dark:text-gray-400">
                Showing
                <span class="font-semibold text-gray-900 dark:text-white"><?php echo e($users['perPage']); ?></span>
                of
                <span class="font-semibold text-gray-900 dark:text-white"><?php echo e($users['total']); ?></span>
            </span> -->
            <?php echo e($users->links()); ?>

        </nav>
    </div>
</div>
<script>
    const showUserModal = async (input) => {

        const modalDetails = document.getElementById(`userModal${input}`);

        if (modalDetails.classList.contains("hidden")) {
            modalDetails.classList.remove("hidden");
        } else {
            modalDetails.classList.add("hidden");
        }

    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.adminDashboard',['title'=> "Users"], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\USER\Documents\GitHub\SPS-ERP\resources\views\admin\users.blade.php ENDPATH**/ ?>