<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('imprests', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('branch_id')->nullable();
            $table->unsignedBigInteger('approved_id')->nullable();
            $table->unsignedBigInteger('paid_id')->nullable();
            $table->unsignedBigInteger('unit_id')->nullable();
            $table->bigInteger('amount');
            $table->longText('accountNumber');
            $table->longText('accountName');
            $table->longText('bank');
            $table->longText('bankCode');
            $table->longText('items');
            $table->enum('status', ["pending", "approved", "paid", "canceled"])->default("pending");
            $table->longText('meta')->nullable();
            $table->longText('note')->nullable();
            $table->foreign('unit_id')->references('id')->on('units');
            $table->foreign('branch_id')->references('id')->on('branch_offices');
            $table->foreign('approved_id')->references('id')->on('users');
            $table->foreign('paid_id')->references('id')->on('users');
            $table->foreign('user_id')->references('id')->on('users');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('imprests');
    }
};
