<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('complaints', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('branch_id');
            $table->unsignedBigInteger('client_id');
            $table->unsignedBigInteger('unit_id');
            $table->enum('type', ["professional conduct", "negligence of duty", "security breaches", "harassment or inappropriate behavior", "failure to report incidents", "unprofessional appearance", "poor communication", "breach of company policy", "lack of vigilance"])->default("professional conduct");
            $table->longText('comment');
            $table->foreign('user_id')->references('id')->on('users');
            $table->foreign('unit_id')->references('id')->on('units');
            $table->foreign('branch_id')->references('id')->on('branch_offices');
            $table->foreign('client_id')->references('id')->on('users');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('complaints');
    }
};
