<style>
    .frame-83 {
        background: #3f4254;
        border-radius: 6px;
        padding: 9px 22px 9px 22px;
        display: flex;
        flex-direction: row;
        gap: 10px;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
        width: 97px;
        height: 38px;

    }

    .add-new {
        color: #ffffff;
        text-align: center;
        font-family: "Inter-SemiBold", sans-serif;
        font-size: 11px;
        line-height: 12px;
        font-weight: 600;

    }
</style>
@extends('layouts.dashboard',['title'=> "Imprest"])
@section('statusmenue')
<div class="lg:flex lg:flex-row px-4 mt-4 w-full">

    <div class="w-full lg:w-1/4 md:w-full mx-2 p-6 bg-white border border-gray-200 rounded-lg shadow-sm dark:bg-gray-800 dark:border-gray-700">

        <img class="w-14 h-14 text-gray-500 dark:text-gray-400 mb-3 border-2 border-solid rounded-xl border-gray-300" src="/icons/breafecase.png" />
        <p class="mb-3 font-normal text-gray-500 dark:text-gray-400">Total Imprest</p>

        <h5 class=" mt-6 text-2xl font-semibold tracking-tight text-gray-900 dark:text-white">{{$countInvoice}}</h5>

    </div>



    <div class="w-full lg:w-1/4 mx-2 p-6 bg-white border border-gray-200 rounded-lg shadow-sm dark:bg-gray-800 dark:border-gray-700">

        <img class="w-14 h-14 text-gray-500 dark:text-gray-400 mb-3 border-2 border-solid rounded-xl border-gray-300" src="/icons/chear.png" />
        <p class="mb-3 font-normal text-gray-500 dark:text-gray-400">Aproved Imprest</p>

        <h5 class=" mt-6 text-2xl font-semibold tracking-tight text-gray-900 dark:text-white">{{$approvedInvoice}}</h5>

    </div>




    <div class="w-full lg:w-1/4 mx-2 p-6 bg-white border border-gray-200 rounded-lg shadow-sm dark:bg-gray-800 dark:border-gray-700">
        <img class="w-14 h-14 text-gray-500 dark:text-gray-400 mb-3 border-2 border-solid rounded-xl border-gray-300" src="/icons/alert.png" />

        <p class="mb-3 font-normal text-gray-500 dark:text-gray-400">Pending Imprest</p>

        <h5 class=" mt-6 text-2xl font-semibold tracking-tight text-gray-900 dark:text-white">{{$pendingInvoice}}</h5>

    </div>




    <div class="w-full lg:w-1/4 mx-2 p-6 bg-white border border-gray-200 rounded-lg shadow-sm dark:bg-gray-800 dark:border-gray-700">
        <img class="w-14 h-14 text-gray-500 dark:text-gray-400 mb-3 border-2 border-solid rounded-xl border-gray-300" src="/icons/clock2.png" />

        <p class="mb-3 font-normal text-gray-500 dark:text-gray-400">Declined Imprest</p>


        <h5 class=" mt-6 text-2xl font-semibold tracking-tight text-gray-900 dark:text-white">{{$canceledInvoice}}</h5>


    </div>

</div>
@stop
@section('content')

<div class="w-full mt-4 relative  shadow-md sm:rounded-lg overflow-auto ">

    <div class="w-full mt-4 relative  shadow-md sm:rounded-lg overflow-auto ">
        <div class="flex items-center justify-between flex-column flex-wrap md:flex-row space-y-4 md:space-y-0 pb-4 bg-white dark:bg-gray-900">

            <div class="mt-2 mx-4">
                <div class="Imprest">
                    Imprest
                </div>
                <div class="pettyCash">
                    You can search any request by user
                </div>
            </div>
            <div class="mt-2 mx-4 flex">
                <label for="table-search" class="sr-only">Search</label>
                <div class="relative">
                    <div class="absolute inset-y-0 rtl:inset-r-0 start-0 flex items-center ps-3 pointer-events-none">
                        <svg class="w-4 h-4 text-gray-500 dark:text-gray-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m19 19-4-4m0-7A7 7 0 1 1 1 8a7 7 0 0 1 14 0Z" />
                        </svg>
                    </div>
                    <input type="text" id="table-search-users" class="block p-2 ps-10 text-sm text-gray-900 border border-gray-300 rounded-lg bg-gray-50 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="Search for users">
                </div>
                <div class="frame-83 mx-2 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300">
                    <a href="/invoice" class="add-new">Add New</a>
                </div>
            </div>
        </div>
        @if(\Session::has('message'))
        <ul class="" style="list-style: none;">
            <li>
                <div class="p-4 mb-4 text-sm text-green-800 rounded-lg bg-green-50 dark:bg-gray-800 dark:text-green-400" role="alert">
                    <span class="font-medium">{{\Session::get('message')}}</span>
                </div>
            </li>
        </ul>
        @endif
        <table class="w-full text-sm text-left rtl:text-right text-gray-500 dark:text-gray-400">
            <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                <tr>

                    <th scope="col" class="px-6 py-3">
                        Account Details
                    </th>
                    <th scope="col" class="px-6 py-3">
                        Bank Details
                    </th>
                    <th scope="col" class="px-6 py-3">
                        Amount ₦/ Status
                    </th>
                    <th scope="col" class="px-6 py-3">
                        Action
                    </th>
                </tr>
            </thead>
            <tbody>
                @if(count($invoices) > 0 )
                @foreach($invoices->all() as $invoice)
                <tr class="bg-white border-b dark:bg-gray-800 dark:border-gray-700 border-gray-200 hover:bg-gray-50 dark:hover:bg-gray-600">

                    <th scope="row" class=" px-6 py-4 text-gray-900 whitespace-nowrap dark:text-white">

                        <a href="/invoice?id={{$invoice->id}}">
                            <div class="ps-3">
                                <div class="text-base font-semibold">{{$invoice->accountName}}</div>
                                <div class="font-normal text-gray-500">{{$invoice->accountNumber}}</div>
                            </div>
                        </a>
                    </th>
                    <td class="px-6 py-4">
                        <div class="flex items-center">
                            {{$invoice->bank}}
                        </div>
                        <div class="flex items-center">
                            {{$invoice->bankCode}}
                        </div>

                    </td>
                    <td class="px-6 py-4">
                        <div class="flex items-center">
                            {{number_format($invoice->amount/100)}}
                        </div>
                        @if($invoice->status=="pending")
                        <div class="flex items-center text-yellow-500">
                            @elseif($invoice->status=="approved" || $invoice->status=="paid")
                            <div class="flex items-center text-green-500">
                                @elseif($invoice->status=="canceled")
                                <div class="flex items-center text-red-500">
                                    @else
                                    <div class="flex items-center">
                                        @endif
                                        {{$invoice->status}}
                                    </div>
                    </td>

                    <td class="flex px-6 py-4">
                        @if($invoice->status=="pending")
                        <a href="/invoice?id={{$invoice->id}}" class="mx-1 h-10 w-10" title="View request">
                            <img class="h-10 w-10 rounded-lg" src="/icons/ButtonEdit.png" alt="" srcset="">
                        </a>
                        <form action="/imprest-cancel" method="post">
                            @csrf
                            <input type="hidden" name="invoiceId" value="{{$invoice->id}}">
                            <button type="submit" title="Cancele request" class="mx-1 h-10 w-10 bg-red-100 rounded-lg hover:bg-red-200 flex justify-center items-center">
                                <img class="h-5 w-5 rounded-lg" src="/icons/cancelled.png" alt="" srcset="">
                            </button>
                        </form>
                        @endif
                    </td>

                </tr>
                @endforeach
                @endif

            </tbody>
        </table>
    </div>
</div>

@stop